/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.state;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.AbstractSqlResult;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.client.SqlPage;
import com.hazelcast.sql.impl.state.QueryClientState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class QueryClientStateRegistry {
    private static final long DEFAULT_CLOSED_CURSOR_CLEANUP_TIMEOUT_NS = TimeUnit.NANOSECONDS.convert(30L, TimeUnit.SECONDS);
    private final ConcurrentHashMap<QueryId, QueryClientState> clientCursors = new ConcurrentHashMap();
    private volatile long closedCursorCleanupTimeoutNs = DEFAULT_CLOSED_CURSOR_CLEANUP_TIMEOUT_NS;

    public SqlPage registerAndFetch(UUID clientId, AbstractSqlResult result, int cursorBufferSize, InternalSerializationService serializationService) {
        QueryId queryId = result.getQueryId();
        QueryClientState clientCursor = new QueryClientState(clientId, queryId, result, false);
        boolean delete = false;
        try {
            QueryClientState previousClientCursor = this.clientCursors.putIfAbsent(queryId, clientCursor);
            if (previousClientCursor != null) {
                assert (previousClientCursor.isClosed());
                delete = true;
                QueryException error = QueryException.cancelledByUser();
                result.close(error);
                throw error;
            }
            SqlPage page = this.fetchInternal(clientCursor, cursorBufferSize, serializationService, result.isInfiniteRows());
            delete = page.isLast();
            SqlPage sqlPage = page;
            return sqlPage;
        }
        catch (Exception e) {
            delete = true;
            throw e;
        }
        finally {
            if (delete) {
                this.deleteClientCursor(queryId);
            }
        }
    }

    public SqlPage fetch(QueryId queryId, int cursorBufferSize, InternalSerializationService serializationService) {
        QueryClientState clientCursor = this.clientCursors.get(queryId);
        if (clientCursor == null) {
            throw QueryException.error("Query cursor is not found (closed?): " + queryId);
        }
        try {
            SqlPage page = this.fetchInternal(clientCursor, cursorBufferSize, serializationService, false);
            if (page.isLast()) {
                this.deleteClientCursor(clientCursor.getQueryId());
            }
            return page;
        }
        catch (Exception e) {
            this.deleteClientCursor(clientCursor.getQueryId());
            throw e;
        }
    }

    private SqlPage fetchInternal(QueryClientState clientCursor, int cursorBufferSize, InternalSerializationService serializationService, boolean respondImmediately) {
        List<SqlColumnMetadata> columns = clientCursor.getSqlResult().getRowMetadata().getColumns();
        ArrayList<SqlColumnType> columnTypes = new ArrayList<SqlColumnType>(columns.size());
        for (SqlColumnMetadata column : columns) {
            columnTypes.add(column.getType());
        }
        if (respondImmediately) {
            return SqlPage.fromRows(columnTypes, Collections.emptyList(), false, serializationService);
        }
        ResultIterator<SqlRow> iterator2 = clientCursor.getIterator();
        try {
            ArrayList<SqlRow> rows = new ArrayList<SqlRow>(cursorBufferSize);
            boolean last = QueryClientStateRegistry.fetchPage(iterator2, rows, cursorBufferSize);
            return SqlPage.fromRows(columnTypes, rows, last, serializationService);
        }
        catch (HazelcastSqlException e) {
            throw e;
        }
        catch (Exception e) {
            AbstractSqlResult result = clientCursor.getSqlResult();
            QueryException error = QueryException.error("Failed to prepare the SQL result for the client: " + e.getMessage(), e);
            result.close(error);
            throw error;
        }
    }

    private static boolean fetchPage(ResultIterator<SqlRow> iterator2, List<SqlRow> rows, int cursorBufferSize) {
        ResultIterator.HasNextResult hasNextResult;
        assert (cursorBufferSize > 0);
        if (!iterator2.hasNext()) {
            return true;
        }
        do {
            rows.add((SqlRow)iterator2.next());
        } while ((hasNextResult = iterator2.hasNext(0L, TimeUnit.SECONDS)) == ResultIterator.HasNextResult.YES && rows.size() < cursorBufferSize);
        return hasNextResult == ResultIterator.HasNextResult.DONE;
    }

    public void close(UUID clientId, QueryId queryId) {
        QueryClientState clientCursor = this.clientCursors.computeIfAbsent(queryId, ignore -> new QueryClientState(clientId, queryId, null, true));
        if (clientCursor.isClosed()) {
            return;
        }
        this.close0(clientCursor);
    }

    public void closeOnError(QueryId queryId) {
        QueryClientState clientCursor = this.clientCursors.get(queryId);
        if (clientCursor != null) {
            this.close0(clientCursor);
        }
    }

    private void close0(QueryClientState clientCursor) {
        AbstractSqlResult result = clientCursor.getSqlResult();
        if (result != null) {
            result.close();
        }
        this.deleteClientCursor(clientCursor.getQueryId());
    }

    public void shutdown() {
        this.clientCursors.clear();
    }

    public void update(Set<UUID> activeClientIds) {
        long currentTimeNano = System.nanoTime();
        ArrayList<QueryClientState> victims = new ArrayList<QueryClientState>();
        for (QueryClientState clientCursor : this.clientCursors.values()) {
            if (!activeClientIds.contains(clientCursor.getClientId())) {
                victims.add(clientCursor);
            }
            if (!clientCursor.isClosed() || clientCursor.getCreatedAtNano() + this.closedCursorCleanupTimeoutNs >= currentTimeNano) continue;
            victims.add(clientCursor);
        }
        for (QueryClientState victim : victims) {
            QueryException error = QueryException.clientMemberConnection(victim.getClientId());
            AbstractSqlResult result = victim.getSqlResult();
            if (result != null) {
                result.close(error);
            }
            this.deleteClientCursor(victim.getQueryId());
        }
    }

    private void deleteClientCursor(QueryId queryId) {
        this.clientCursors.remove(queryId);
    }

    public int getCursorCount() {
        return this.clientCursors.size();
    }

    public void setClosedCursorCleanupTimeoutSeconds(long closedCursorCleanupTimeout) {
        this.closedCursorCleanupTimeoutNs = TimeUnit.NANOSECONDS.convert(closedCursorCleanupTimeout, TimeUnit.SECONDS);
    }
}

