/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.proxyservice.impl;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.InitializingObject;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;

public class DistributedObjectFuture
implements ForkJoinPool.ManagedBlocker {
    private volatile DistributedObject proxy;
    private volatile Throwable error;
    private volatile DistributedObject rawProxy;
    private final UUID source;

    public DistributedObjectFuture(UUID source2) {
        this.source = source2;
    }

    boolean isSetAndInitialized() {
        return this.proxy != null || this.error != null;
    }

    public DistributedObject get() {
        if (this.proxy != null) {
            return this.proxy;
        }
        if (this.error != null) {
            throw ExceptionUtil.rethrow(this.error);
        }
        try {
            ForkJoinPool.managedBlock(this);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.error = e;
        }
        if (this.proxy != null) {
            return this.proxy;
        }
        throw ExceptionUtil.rethrow(this.error);
    }

    @Override
    public boolean block() throws InterruptedException {
        if (Thread.currentThread().isInterrupted() || this.isReleasable()) {
            return true;
        }
        if (this.waitUntilSetAndInitialized()) {
            Thread.currentThread().interrupt();
            return true;
        }
        return true;
    }

    @Override
    public boolean isReleasable() {
        return this.proxy != null;
    }

    public UUID getSource() {
        return this.source;
    }

    public DistributedObject getNow() {
        if (this.error != null) {
            throw ExceptionUtil.rethrow(this.error);
        }
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitUntilSetAndInitialized() {
        boolean interrupted = false;
        DistributedObjectFuture distributedObjectFuture = this;
        synchronized (distributedObjectFuture) {
            while (this.proxy == null && this.error == null) {
                if (this.rawProxy != null) {
                    this.initialize();
                    break;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        return interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        DistributedObjectFuture distributedObjectFuture = this;
        synchronized (distributedObjectFuture) {
            try {
                InitializingObject o = (InitializingObject)((Object)this.rawProxy);
                o.initialize();
                this.proxy = this.rawProxy;
            }
            catch (Throwable e) {
                this.error = e;
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(DistributedObject o, boolean initialized) {
        if (o == null) {
            throw new IllegalArgumentException("Proxy must not be null!");
        }
        DistributedObjectFuture distributedObjectFuture = this;
        synchronized (distributedObjectFuture) {
            if (this.error == null) {
                if (!initialized && o instanceof InitializingObject) {
                    this.rawProxy = o;
                } else {
                    this.proxy = o;
                }
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setError(Throwable t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("Error must not be null!");
        }
        if (this.proxy != null) {
            throw new IllegalStateException("Proxy is already set! Proxy: " + this.proxy + ", error: " + t2);
        }
        DistributedObjectFuture distributedObjectFuture = this;
        synchronized (distributedObjectFuture) {
            this.error = t2;
            this.notifyAll();
        }
    }
}

