/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.com.fasterxml.jackson.jr.annotationsupport;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.JSON;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import com.hazelcast.shaded.com.fasterxml.jackson.jr.ob.impl.POJODefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class AnnotationBasedIntrospector {
    protected final Class<?> _type;
    protected final boolean _forSerialization;
    protected final JsonAutoDetect.Value _visibility;
    protected final Map<String, APropBuilder> _props = new HashMap<String, APropBuilder>();
    protected Set<String> _ignorableNames;
    protected int _features;

    protected AnnotationBasedIntrospector(Class<?> clazz, boolean bl, JsonAutoDetect.Value value, int n) {
        this._type = clazz;
        this._forSerialization = bl;
        this._ignorableNames = bl ? null : new HashSet();
        this._features = n;
        JsonAutoDetect jsonAutoDetect = this._find(clazz, JsonAutoDetect.class);
        this._visibility = jsonAutoDetect == null ? value : value.withOverrides(JsonAutoDetect.Value.from(jsonAutoDetect));
    }

    public static POJODefinition pojoDefinitionForDeserialization(JSONReader jSONReader, Class<?> clazz, JsonAutoDetect.Value value) {
        return new AnnotationBasedIntrospector(clazz, false, value, jSONReader.features()).introspectDefinition();
    }

    public static POJODefinition pojoDefinitionForSerialization(JSONWriter jSONWriter, Class<?> clazz, JsonAutoDetect.Value value) {
        return new AnnotationBasedIntrospector(clazz, true, value, jSONWriter.features()).introspectDefinition();
    }

    protected POJODefinition introspectDefinition() {
        this._findFields();
        this._findMethods();
        Constructor<?> constructor = null;
        Constructor<?> constructor2 = null;
        Constructor<?> constructor3 = null;
        if (!this._forSerialization) {
            for (Constructor<?> constructor4 : this._type.getDeclaredConstructors()) {
                Class<?>[] classArray = constructor4.getParameterTypes();
                if (classArray.length == 0) {
                    constructor = constructor4;
                    continue;
                }
                if (classArray.length != 1) continue;
                Class<?> clazz = classArray[0];
                if (clazz == String.class) {
                    constructor2 = constructor4;
                    continue;
                }
                if (clazz != Long.class && clazz != Long.TYPE) continue;
                constructor3 = constructor4;
            }
        }
        Object object = new POJODefinition(this._type, this._pruneProperties(this._forSerialization), constructor, constructor2, constructor3);
        if (this._ignorableNames != null) {
            object = ((POJODefinition)object).withIgnorals(this._ignorableNames);
        }
        return object;
    }

    protected POJODefinition.Prop[] _pruneProperties(boolean bl) {
        boolean bl2;
        Object object;
        Object object2;
        Object object3;
        LinkedList<APropBuilder> linkedList = null;
        Iterator<APropBuilder> iterator2 = this._props.values().iterator();
        while (iterator2.hasNext()) {
            object3 = iterator2.next();
            if (((APropBuilder)object3).anyIgnorals()) {
                if (!((APropBuilder)object3).anyExplicit()) {
                    iterator2.remove();
                    this._addIgnoral(((APropBuilder)object3).name);
                    continue;
                }
                ((APropBuilder)object3).removeIgnored();
                if (((APropBuilder)object3).couldDeserialize()) continue;
                this._addIgnoral(((APropBuilder)object3).name);
                continue;
            }
            if (!((APropBuilder)object3).anyVisible()) {
                iterator2.remove();
                continue;
            }
            ((APropBuilder)object3).removeNonVisible();
            object2 = ((APropBuilder)object3).findPrimaryExplicitName(this._forSerialization);
            if (object2 == null) continue;
            iterator2.remove();
            if (linkedList == null) {
                linkedList = new LinkedList<APropBuilder>();
            }
            linkedList.add(((APropBuilder)object3).withName((String)object2));
        }
        if (linkedList != null) {
            object3 = linkedList.iterator();
            while (object3.hasNext()) {
                object2 = (APropBuilder)object3.next();
                object = this._props.get(((APropBuilder)object2).name);
                if (object == null) {
                    this._props.put(((APropBuilder)object2).name, (APropBuilder)object2);
                    continue;
                }
                APropBuilder aPropBuilder = APropBuilder.merge((APropBuilder)object, (APropBuilder)object2);
                this._props.put(((APropBuilder)object2).name, aPropBuilder);
            }
        }
        if (!(object3 = this._findIgnorableNames()).isEmpty()) {
            if (this._ignorableNames != null) {
                this._ignorableNames.addAll((Collection<String>)object3);
            }
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this._findAndRemoveByName((String)object);
            }
        }
        int n = this._props.size();
        object = new POJODefinition.Prop[n];
        int n2 = 0;
        boolean bl3 = bl2 = !this._forSerialization;
        if (bl) {
            List<String> list = this._findNameSortOrder();
            if (!list.isEmpty()) {
                for (String object4 : list) {
                    APropBuilder aPropBuilder = this._findAndRemoveByName(object4);
                    if (aPropBuilder == null) continue;
                    object[n2++] = aPropBuilder.asProperty(bl2);
                }
            }
            TreeMap<String, APropBuilder> treeMap = new TreeMap<String, APropBuilder>(this._props);
            for (APropBuilder aPropBuilder : treeMap.values()) {
                object[n2++] = aPropBuilder.asProperty(bl2);
            }
        } else {
            for (APropBuilder aPropBuilder : this._props.values()) {
                object[n2++] = aPropBuilder.asProperty(bl2);
            }
        }
        return object;
    }

    protected void _findFields() {
        this._findFields(this._type);
    }

    protected void _findFields(Class<?> clazz) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        this._findFields(clazz.getSuperclass());
        for (Field field : clazz.getDeclaredFields()) {
            String string;
            if (JSON.Feature.INCLUDE_STATIC_FIELDS.isDisabled(this._features) && Modifier.isStatic(field.getModifiers()) && !field.isEnumConstant() || field.isSynthetic()) continue;
            String string2 = field.getName();
            APropAccessor<Field> aPropAccessor = Boolean.TRUE.equals(this._hasIgnoreMarker(field)) ? APropAccessor.createIgnorable(string2, field) : ((string = this._findExplicitName(field)) != null ? (string.isEmpty() ? APropAccessor.createVisible(string2, field) : APropAccessor.createExplicit(string, field)) : APropAccessor.createImplicit(string, field, this._isFieldVisible(field)));
            this._propBuilder((String)string2).field = aPropAccessor;
        }
    }

    protected void _findMethods() {
        this._findMethods(this._type);
    }

    protected void _findMethods(Class<?> clazz) {
        if (clazz == null || clazz == Object.class || clazz == Enum.class) {
            return;
        }
        this._findMethods(clazz.getSuperclass());
        for (Method method : clazz.getDeclaredMethods()) {
            int n = method.getModifiers();
            if (Modifier.isStatic(n) || method.isSynthetic() || method.isBridge()) continue;
            int n2 = method.getParameterCount();
            if (n2 == 0) {
                this._checkGetterMethod(method);
                continue;
            }
            if (n2 != 1) continue;
            this._checkSetterMethod(method);
        }
    }

    protected void _checkGetterMethod(Method method) {
        APropAccessor<Method> aPropAccessor;
        Class<?> clazz = method.getReturnType();
        if (clazz == Void.class) {
            return;
        }
        String string = method.getName();
        String string2 = null;
        boolean bl = false;
        if (string.startsWith("get")) {
            if (string.length() > 3) {
                string2 = AnnotationBasedIntrospector._decap(string.substring(3));
            }
        } else if (string.startsWith("is") && string.length() > 2) {
            string2 = AnnotationBasedIntrospector._decap(string.substring(2));
            bl = true;
        }
        if (string2 == null) {
            String string3 = this._findExplicitName(method);
            if (string3 == null) {
                return;
            }
            string2 = string;
            aPropAccessor = Boolean.TRUE.equals(this._hasIgnoreMarker(method)) ? APropAccessor.createIgnorable(string2, method) : (string3.isEmpty() ? APropAccessor.createVisible(string2, method) : APropAccessor.createExplicit(string3, method));
        } else {
            String string4;
            aPropAccessor = Boolean.TRUE.equals(this._hasIgnoreMarker(method)) ? APropAccessor.createIgnorable(string2, method) : ((string4 = this._findExplicitName(method)) == null ? APropAccessor.createImplicit(string2, method, this._isGetterVisible(method, bl)) : (string4.isEmpty() ? APropAccessor.createVisible(string2, method) : APropAccessor.createExplicit(string4, method)));
        }
        this._propBuilder((String)string2).getter = aPropAccessor;
    }

    protected void _checkSetterMethod(Method method) {
        APropAccessor<Method> aPropAccessor;
        String string = method.getName();
        String string2 = string.startsWith("set") && string.length() > 3 ? AnnotationBasedIntrospector._decap(string.substring(3)) : null;
        if (string2 == null) {
            String string3 = this._findExplicitName(method);
            if (string3 == null) {
                return;
            }
            string2 = string;
            aPropAccessor = Boolean.TRUE.equals(this._hasIgnoreMarker(method)) ? APropAccessor.createIgnorable(string2, method) : (string3.isEmpty() ? APropAccessor.createVisible(string2, method) : APropAccessor.createExplicit(string3, method));
        } else {
            String string4;
            aPropAccessor = Boolean.TRUE.equals(this._hasIgnoreMarker(method)) ? APropAccessor.createIgnorable(string2, method) : ((string4 = this._findExplicitName(method)) == null ? APropAccessor.createImplicit(string2, method, this._isSetterVisible(method)) : (string4.isEmpty() ? APropAccessor.createVisible(string2, method) : APropAccessor.createExplicit(string4, method)));
        }
        this._propBuilder((String)string2).setter = aPropAccessor;
    }

    protected boolean _isFieldVisible(Field field) {
        return (!Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.isEnumConstant()) && !Modifier.isTransient(field.getModifiers()) && this._visibility.getFieldVisibility().isVisible(field);
    }

    protected boolean _isGetterVisible(Method method, boolean bl) {
        if (bl) {
            return this._visibility.getIsGetterVisibility().isVisible(method);
        }
        return this._visibility.getGetterVisibility().isVisible(method);
    }

    protected boolean _isSetterVisible(Method method) {
        return this._visibility.getSetterVisibility().isVisible(method);
    }

    protected Boolean _hasIgnoreMarker(AnnotatedElement annotatedElement) {
        JsonIgnore jsonIgnore = this._find(annotatedElement, JsonIgnore.class);
        return jsonIgnore != null && jsonIgnore.value();
    }

    protected String _findExplicitName(AnnotatedElement annotatedElement) {
        JsonProperty jsonProperty = this._find(annotatedElement, JsonProperty.class);
        return jsonProperty == null ? null : jsonProperty.value();
    }

    protected List<String> _findNameSortOrder() {
        JsonPropertyOrder jsonPropertyOrder = this._find(this._type, JsonPropertyOrder.class);
        if (jsonPropertyOrder == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(jsonPropertyOrder.value());
    }

    protected Collection<String> _findIgnorableNames() {
        JsonIgnoreProperties jsonIgnoreProperties = this._find(this._type, JsonIgnoreProperties.class);
        if (jsonIgnoreProperties == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(jsonIgnoreProperties.value());
    }

    protected <ANN extends Annotation> ANN _find(AnnotatedElement annotatedElement, Class<ANN> clazz) {
        return annotatedElement.getAnnotation(clazz);
    }

    protected APropBuilder _propBuilder(String string) {
        APropBuilder aPropBuilder = this._props.get(string);
        if (aPropBuilder == null) {
            aPropBuilder = new APropBuilder(string);
            this._props.put(string, aPropBuilder);
        }
        return aPropBuilder;
    }

    protected void _addIgnoral(String string) {
        if (this._ignorableNames != null) {
            this._ignorableNames.add(string);
        }
    }

    protected APropBuilder _findAndRemoveByName(String string) {
        APropBuilder aPropBuilder = this._props.remove(string);
        if (aPropBuilder == null) {
            for (APropBuilder aPropBuilder2 : this._props.values()) {
                aPropBuilder = this._props.remove(aPropBuilder2.origName);
                if (aPropBuilder == null) continue;
                break;
            }
        }
        return aPropBuilder;
    }

    protected static String _decap(String string) {
        char c;
        char c2 = string.charAt(0);
        if (!(c2 == (c = Character.toLowerCase(c2)) || string.length() != 1 && Character.isUpperCase(string.charAt(1)))) {
            char[] cArray = string.toCharArray();
            cArray[0] = c;
            return new String(cArray);
        }
        return string;
    }

    protected static class APropAccessor<ACC extends AccessibleObject> {
        public final String name;
        public final ACC accessor;
        public final boolean isExplicit;
        public final boolean isNameExplicit;
        public final boolean isToIgnore;
        public final boolean isVisible;

        protected APropAccessor(String string, ACC ACC, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.name = string;
            this.accessor = ACC;
            this.isExplicit = bl;
            this.isNameExplicit = bl2;
            this.isToIgnore = bl3;
            this.isVisible = bl4;
        }

        public static <T extends AccessibleObject> APropAccessor<T> createIgnorable(String string, T t2) {
            return new APropAccessor<T>(string, t2, false, false, true, false);
        }

        public static <T extends AccessibleObject> APropAccessor<T> createImplicit(String string, T t2, boolean bl) {
            return new APropAccessor<T>(string, t2, false, false, false, bl);
        }

        public static <T extends AccessibleObject> APropAccessor<T> createVisible(String string, T t2) {
            return new APropAccessor<T>(string, t2, true, false, false, true);
        }

        public static <T extends AccessibleObject> APropAccessor<T> createExplicit(String string, T t2) {
            return new APropAccessor<T>(string, t2, true, true, false, true);
        }
    }

    protected static class APropBuilder
    implements Comparable<APropBuilder> {
        public final String origName;
        public final String name;
        protected APropAccessor<Field> field;
        protected APropAccessor<Method> getter;
        protected APropAccessor<Method> setter;

        public APropBuilder(String string) {
            this.origName = string;
            this.name = string;
        }

        protected APropBuilder(APropBuilder aPropBuilder, String string) {
            this.origName = aPropBuilder.origName;
            this.name = string;
        }

        public POJODefinition.Prop asProperty(boolean bl) {
            Set<String> set = bl ? this.collectAliases() : null;
            return new POJODefinition.Prop(this.name, this.field == null ? null : (Field)this.field.accessor, this.setter == null ? null : (Method)this.setter.accessor, this.getter == null ? null : (Method)this.getter.accessor, null, set);
        }

        public static APropBuilder merge(APropBuilder aPropBuilder, APropBuilder aPropBuilder2) {
            APropBuilder aPropBuilder3 = new APropBuilder(aPropBuilder.name);
            aPropBuilder3.field = APropBuilder._merge(aPropBuilder.field, aPropBuilder2.field);
            aPropBuilder3.getter = APropBuilder._merge(aPropBuilder.getter, aPropBuilder2.getter);
            aPropBuilder3.setter = APropBuilder._merge(aPropBuilder.setter, aPropBuilder2.setter);
            return aPropBuilder3;
        }

        private static <A extends AccessibleObject> APropAccessor<A> _merge(APropAccessor<A> aPropAccessor, APropAccessor<A> aPropAccessor2) {
            if (aPropAccessor == null) {
                return aPropAccessor2;
            }
            if (aPropAccessor2 == null) {
                return aPropAccessor;
            }
            if (aPropAccessor.isNameExplicit) {
                return aPropAccessor;
            }
            if (aPropAccessor2.isNameExplicit) {
                return aPropAccessor2;
            }
            if (aPropAccessor.isExplicit) {
                return aPropAccessor;
            }
            if (aPropAccessor2.isExplicit) {
                return aPropAccessor2;
            }
            return aPropAccessor;
        }

        public APropBuilder withName(String string) {
            APropBuilder aPropBuilder = new APropBuilder(this, string);
            aPropBuilder.field = this.field;
            aPropBuilder.getter = this.getter;
            aPropBuilder.setter = this.setter;
            return aPropBuilder;
        }

        public void removeIgnored() {
            if (this.field != null && this.field.isToIgnore) {
                this.field = null;
            }
            if (this.getter != null && this.getter.isToIgnore) {
                this.getter = null;
            }
            if (this.setter != null && this.setter.isToIgnore) {
                this.setter = null;
            }
        }

        public void removeNonVisible() {
            if (this.field != null && !this.field.isVisible) {
                this.field = null;
            }
            if (this.getter != null && !this.getter.isVisible) {
                this.getter = null;
            }
            if (this.setter != null && !this.setter.isVisible) {
                this.setter = null;
            }
        }

        public Set<String> collectAliases() {
            Set<String> set = null;
            set = APropBuilder._collectAliases(this.field, set);
            set = APropBuilder._collectAliases(this.getter, set);
            set = APropBuilder._collectAliases(this.setter, set);
            return set;
        }

        private static Set<String> _collectAliases(APropAccessor<?> aPropAccessor, Set<String> set) {
            JsonAlias jsonAlias;
            Object ACC;
            if (aPropAccessor != null && (ACC = aPropAccessor.accessor) != null && (jsonAlias = ACC.getAnnotation(JsonAlias.class)) != null) {
                String[] stringArray = jsonAlias.value();
                if (set == null) {
                    set = new HashSet<String>();
                }
                for (String string : stringArray) {
                    set.add(string);
                }
            }
            return set;
        }

        private String _firstExplicit(APropAccessor<?> aPropAccessor, APropAccessor<?> aPropAccessor2, APropAccessor<?> aPropAccessor3) {
            if (aPropAccessor != null && aPropAccessor.isNameExplicit) {
                return aPropAccessor.name;
            }
            if (aPropAccessor2 != null && aPropAccessor2.isNameExplicit) {
                return aPropAccessor2.name;
            }
            if (aPropAccessor3 != null && aPropAccessor3.isNameExplicit) {
                return aPropAccessor3.name;
            }
            return null;
        }

        public String findPrimaryExplicitName(boolean bl) {
            if (bl) {
                return this._firstExplicit(this.getter, this.setter, this.field);
            }
            return this._firstExplicit(this.setter, this.getter, this.field);
        }

        public boolean anyVisible() {
            return this.field != null && this.field.isVisible || this.getter != null && this.getter.isVisible || this.setter != null && this.setter.isVisible;
        }

        public boolean anyExplicit() {
            return this.field != null && this.field.isExplicit || this.getter != null && this.getter.isExplicit || this.setter != null && this.setter.isExplicit;
        }

        public boolean anyIgnorals() {
            return this.field != null && this.field.isToIgnore || this.getter != null && this.getter.isToIgnore || this.setter != null && this.setter.isToIgnore;
        }

        public boolean couldDeserialize() {
            return this.field != null || this.setter != null;
        }

        @Override
        public int compareTo(APropBuilder aPropBuilder) {
            return this.name.compareTo(aPropBuilder.name);
        }
    }
}

