/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.UtilSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;

public enum ClearOpSteps implements IMapOpStep
{
    CLEAR_MEMORY{

        @Override
        public void runStep(State state) {
            final DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            if (recordStore == null) {
                state.setResult(0);
                return;
            }
            recordStore.checkIfLoaded();
            final ArrayList<Data> keys2 = new ArrayList<Data>();
            final ArrayList<Record> records = new ArrayList<Record>();
            recordStore.forEach(new BiConsumer<Data, Record>(){
                final Set<Data> lockedKeySet;
                {
                    this.lockedKeySet = recordStore.getLockStore().getLockedKeys();
                }

                @Override
                public void accept(Data dataKey, Record record) {
                    if (this.lockedKeySet != null && !this.lockedKeySet.contains(dataKey)) {
                        keys2.add(dataKey);
                        records.add(record);
                    }
                }
            }, false);
            state.setKeys(keys2);
            state.setRecords(records);
        }

        @Override
        public Step nextStep(State state) {
            return state.getRecordStore() == null ? UtilSteps.FINAL_STEP : CLEAR_MAP_STORE;
        }
    }
    ,
    CLEAR_MAP_STORE{

        @Override
        public boolean isStoreStep() {
            return true;
        }

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            Collection<Data> keys2 = state.getKeys();
            recordStore.getMapDataStore().removeAll(keys2);
            recordStore.getMapDataStore().reset();
        }

        public ClearOpSteps nextStep(State state) {
            return ON_CLEAR;
        }
    }
    ,
    ON_CLEAR{

        @Override
        public void runStep(State state) {
            DefaultRecordStore recordStore = (DefaultRecordStore)state.getRecordStore();
            int removedKeyCount = recordStore.removeBulk((ArrayList)state.getKeys(), state.getRecords(), false);
            if (removedKeyCount > 0) {
                recordStore.updateStatsOnRemove(Clock.currentTimeMillis());
            }
            state.setResult(removedKeyCount);
        }

        @Override
        public Step nextStep(State state) {
            return UtilSteps.FINAL_STEP;
        }
    };

}

