/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.operation.AbstractMapOperationFactory;
import com.hazelcast.map.impl.operation.GetAllOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MapGetAllOperationFactory
extends AbstractMapOperationFactory {
    private String name;
    private List<Data> keys = new ArrayList<Data>();

    public MapGetAllOperationFactory() {
    }

    public MapGetAllOperationFactory(String name, List<Data> keys2) {
        this.name = name;
        this.keys = keys2;
    }

    @Override
    public Operation createOperation() {
        return new GetAllOperation(this.name, this.keys);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.keys.size());
        for (Data key : this.keys) {
            IOUtil.writeData(out, key);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Data data = IOUtil.readData(in);
            this.keys.add(data);
        }
    }

    @Override
    public int getClassId() {
        return 80;
    }
}

