/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.monitor.impl.LocalRecordStoreStatsImpl;
import com.hazelcast.internal.nearcache.impl.invalidation.Invalidator;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindStore;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntries;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import com.hazelcast.map.impl.nearcache.MapNearCacheManager;
import com.hazelcast.map.impl.operation.MapChunkContext;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryReason;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.MapIndexInfo;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Predicate;

public class MapChunk
extends Operation
implements IdentifiedDataSerializable,
Versioned {
    private static final int DISPOSE_AT_COUNT = 1024;
    protected transient ILogger logger;
    protected transient MapChunkContext context;
    protected transient Predicate isEndOfChunk;
    protected transient String mapName;
    private transient boolean loaded;
    private transient long currentSequence;
    private transient boolean hasWriteBehindState;
    private transient Queue sequences;
    private transient Map counterByTxnId;
    private transient UUID partitionUuid;
    private transient MapIndexInfo mapIndexInfo;
    private transient LinkedList keyRecordExpiry;
    private transient LocalRecordStoreStatsImpl stats;
    private transient List<DelayedEntry> delayedEntriesList;
    private boolean firstChunk;
    private boolean lastChunk;

    public MapChunk() {
    }

    public MapChunk(MapChunkContext context, int chunkNumber, Predicate isEndOfChunk) {
        this.context = context;
        this.isEndOfChunk = isEndOfChunk;
        this.firstChunk = chunkNumber == 1;
        this.logger = context.getLogger(this.getClass().getName());
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("mapName:%s, chunkNumber:%d, partitionId:%d", context.getMapName(), chunkNumber, context.getPartitionId()));
        }
    }

    @Override
    public final void run() throws Exception {
        RecordStore recordStore = this.getRecordStore(this.mapName);
        if (this.firstChunk) {
            this.addIndexes(recordStore, this.mapIndexInfo.getIndexConfigs());
            this.initializeRecordStore(this.mapName, recordStore);
            recordStore.setLocalRecordStoreStats(this.stats);
            recordStore.setPreMigrationLoadedStatus(this.loaded);
            this.applyWriteBehindState(recordStore);
            this.applyNearCacheState(recordStore);
            this.applyIndexStateBefore(recordStore);
        }
        if (CollectionUtil.isNotEmpty(this.keyRecordExpiry)) {
            this.putInto(recordStore);
            this.logProgress(recordStore);
        }
        if (this.lastChunk) {
            this.applyIndexStateAfter(recordStore);
        }
    }

    @Override
    public final void beforeRun() {
        RecordStore recordStore = this.getRecordStore(this.mapName);
        recordStore.beforeOperation();
    }

    @Override
    public final void afterRunFinal() {
        RecordStore recordStore = this.getRecordStore(this.mapName);
        recordStore.afterOperation();
    }

    protected void incrementReplicationCount() {
        this.context.getMapStats().getReplicationStats().incrementFullPartitionReplicationCount();
    }

    protected void incrementReplicationRecordCount(long delta) {
        this.context.getMapStats().getReplicationStats().incrementFullPartitionReplicationRecordsCount(delta);
    }

    protected void initializeRecordStore(String mapName, RecordStore recordStore) {
        recordStore.reset();
    }

    private void putInto(RecordStore recordStore) {
        if (MapChunk.hasPerNodeEviction(recordStore)) {
            this.putOrUpdateReplicatedDataWithPerNodeEviction(recordStore);
        } else {
            this.putOrUpdateReplicatedData(recordStore);
        }
    }

    private void logProgress(RecordStore recordStore) {
        ILogger logger2 = recordStore.getMapContainer().getMapServiceContext().getNodeEngine().getLogger(this.getClass().getName());
        if (logger2.isFinestEnabled()) {
            logger2.finest(String.format("mapName:%s, partitionId:%d, numberOfEntriesMigrated:%d", this.mapName, this.getPartitionId(), this.keyRecordExpiry.size() / 3));
        }
    }

    private void applyIndexStateAfter(RecordStore recordStore) {
        MapContainer mapContainer = recordStore.getMapContainer();
        Indexes indexes = mapContainer.getIndexes(recordStore.getPartitionId());
        if (!this.indexesMustBePopulated(indexes)) {
            return;
        }
        Indexes.markPartitionAsIndexed(this.getPartitionId(), indexes.getIndexes());
    }

    private void applyIndexStateBefore(RecordStore recordStore) {
        MapContainer mapContainer = recordStore.getMapContainer();
        PartitionContainer partitionContainer = mapContainer.getMapServiceContext().getPartitionContainer(this.getPartitionId());
        for (Map.Entry<String, IndexConfig> indexDefinition : mapContainer.getIndexDefinitions().entrySet()) {
            Indexes indexes = mapContainer.getIndexes(partitionContainer.getPartitionId());
            indexes.addOrGetIndex(indexDefinition.getValue());
        }
        Indexes indexes = mapContainer.getIndexes(partitionContainer.getPartitionId());
        boolean populateIndexes = this.indexesMustBePopulated(indexes);
        if (populateIndexes) {
            Indexes.beginPartitionUpdate(indexes.getIndexes());
            indexes.clearAll();
        }
    }

    private void putOrUpdateReplicatedData(RecordStore recordStore) {
        long nowInMillis = Clock.currentTimeMillis();
        int count = 0;
        do {
            Data dataKey = (Data)this.keyRecordExpiry.poll();
            Record record = (Record)this.keyRecordExpiry.poll();
            ExpiryMetadata expiryMetadata = (ExpiryMetadata)this.keyRecordExpiry.poll();
            Indexes indexes = recordStore.getMapContainer().getIndexes(recordStore.getPartitionId());
            recordStore.putOrUpdateReplicatedRecord(dataKey, record, expiryMetadata, this.indexesMustBePopulated(indexes), nowInMillis);
            if (recordStore.shouldEvict()) {
                recordStore.evictEntries(dataKey);
                break;
            }
            if (++count % 1024 != 0) continue;
            recordStore.disposeDeferredBlocks();
        } while (!this.keyRecordExpiry.isEmpty());
        recordStore.disposeDeferredBlocks();
    }

    private void putOrUpdateReplicatedDataWithPerNodeEviction(RecordStore recordStore) {
        MapContainer mapContainer = recordStore.getMapContainer();
        EvictionConfig evictionConfig = mapContainer.getMapConfig().getEvictionConfig();
        long ownedEntryCountOnThisNode = this.entryCountOnThisNode(mapContainer);
        int count = 0;
        long nowInMillis = Clock.currentTimeMillis();
        do {
            Data dataKey = (Data)this.keyRecordExpiry.poll();
            Record record = (Record)this.keyRecordExpiry.poll();
            ExpiryMetadata expiryMetadata = (ExpiryMetadata)this.keyRecordExpiry.poll();
            if (ownedEntryCountOnThisNode >= (long)evictionConfig.getSize()) {
                if (this.getReplicaIndex() == 0) {
                    recordStore.doPostEvictionOperations(dataKey, record.getValue(), ExpiryReason.NOT_EXPIRED);
                }
            } else {
                Indexes indexes = mapContainer.getIndexes(recordStore.getPartitionId());
                recordStore.putOrUpdateReplicatedRecord(dataKey, record, expiryMetadata, this.indexesMustBePopulated(indexes), nowInMillis);
                ++ownedEntryCountOnThisNode;
            }
            if (++count % 1024 != 0) continue;
            recordStore.disposeDeferredBlocks();
        } while (!this.keyRecordExpiry.isEmpty());
        recordStore.disposeDeferredBlocks();
    }

    private long entryCountOnThisNode(MapContainer mapContainer) {
        int replicaIndex = this.getReplicaIndex();
        long owned = 0L;
        MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
        IPartitionService partitionService = mapServiceContext.getNodeEngine().getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        for (int partitionId = 0; partitionId < partitionCount; ++partitionId) {
            RecordStore store;
            if (!(replicaIndex == 0 ? partitionService.isPartitionOwner(partitionId) : !partitionService.isPartitionOwner(partitionId)) || (store = mapServiceContext.getExistingRecordStore(partitionId, mapContainer.getName())) == null) continue;
            owned += (long)store.size();
        }
        return owned;
    }

    private static boolean hasPerNodeEviction(RecordStore recordStore) {
        MapContainer mapContainer = recordStore.getMapContainer();
        EvictionConfig evictionConfig = mapContainer.getMapConfig().getEvictionConfig();
        return mapContainer.getEvictor() != Evictor.NULL_EVICTOR && evictionConfig.getMaxSizePolicy() == MaxSizePolicy.PER_NODE;
    }

    private void applyNearCacheState(RecordStore recordStore) {
        MetaDataGenerator metaDataGenerator = this.getPartitionMetaDataGenerator(recordStore);
        int partitionId = this.getPartitionId();
        if (this.partitionUuid != null) {
            metaDataGenerator.setUuid(partitionId, this.partitionUuid);
        }
        metaDataGenerator.setCurrentSequence(recordStore.getName(), partitionId, this.currentSequence);
    }

    private void applyWriteBehindState(RecordStore recordStore) {
        if (!this.hasWriteBehindState) {
            return;
        }
        WriteBehindStore mapDataStore = (WriteBehindStore)recordStore.getMapDataStore();
        mapDataStore.getTxnReservedCapacityCounter().putAll(this.counterByTxnId);
        mapDataStore.reset();
        mapDataStore.setFlushSequences(this.sequences);
        for (DelayedEntry delayedEntry : this.delayedEntriesList) {
            mapDataStore.addForcibly(delayedEntry);
            mapDataStore.setSequence(delayedEntry.getSequence());
        }
    }

    private void addIndexes(RecordStore recordStore, Collection<IndexConfig> indexConfigs) {
        if (indexConfigs == null) {
            return;
        }
        MapContainer mapContainer = recordStore.getMapContainer();
        if (mapContainer.isGlobalIndexEnabled()) {
            for (IndexConfig indexConfig : indexConfigs) {
                Indexes indexes = mapContainer.getIndexes();
                if (indexes.getIndex(indexConfig.getName()) != null) continue;
                indexes.addOrGetIndex(indexConfig);
            }
        } else {
            Indexes indexes = mapContainer.getIndexes(this.getPartitionId());
            indexes.createIndexesFromRecordedDefinitions();
            for (IndexConfig indexConfig : indexConfigs) {
                indexes.addOrGetIndex(indexConfig);
            }
        }
    }

    private boolean indexesMustBePopulated(Indexes indexes) {
        if (!indexes.haveAtLeastOneIndex()) {
            return false;
        }
        if (indexes.isGlobal()) {
            return false;
        }
        return this.getReplicaIndex() == 0;
    }

    private RecordStore getRecordStore(String mapName) {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        return mapServiceContext.getRecordStore(this.getPartitionId(), mapName, true);
    }

    @Override
    protected final void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.firstChunk);
        if (this.firstChunk) {
            this.writeMetadata(out);
        }
        this.context.beforeOperation();
        try {
            this.writeChunk(out, this.context);
            Iterator<Map.Entry<Data, Record>> iterator2 = this.context.getIterator();
            this.lastChunk = !iterator2.hasNext();
            this.context.setIterator(iterator2);
        }
        finally {
            this.context.afterOperation();
        }
        out.writeBoolean(this.lastChunk);
    }

    protected void writeMetadata(ObjectDataOutput out) throws IOException {
        out.writeObject(this.context.createMapIndexInfo());
        out.writeBoolean(this.context.isRecordStoreLoaded());
        this.context.getLocalRecordStoreStats().writeData(out);
        this.writeWriteBehindState(out, this.context.getRecordStore());
        this.writeNearCacheState(out);
    }

    public final void writeNearCacheState(ObjectDataOutput out) throws IOException {
        int partitionId;
        MetaDataGenerator metaData = this.getPartitionMetaDataGenerator(this.context.getRecordStore());
        UUID partitionUuid = metaData.getOrCreateUuid(partitionId = this.context.getPartitionId());
        boolean nullUuid = partitionUuid == null;
        out.writeBoolean(nullUuid);
        if (!nullUuid) {
            out.writeLong(partitionUuid.getMostSignificantBits());
            out.writeLong(partitionUuid.getLeastSignificantBits());
        }
        long currentSequence = metaData.currentSequence(this.context.getMapName(), partitionId);
        out.writeLong(currentSequence);
    }

    public final void readNearCacheState(ObjectDataInput in) throws IOException {
        boolean nullUuid = in.readBoolean();
        this.partitionUuid = nullUuid ? null : new UUID(in.readLong(), in.readLong());
        this.currentSequence = in.readLong();
    }

    private MetaDataGenerator getPartitionMetaDataGenerator(RecordStore recordStore) {
        MapServiceContext mapServiceContext = recordStore.getMapContainer().getMapServiceContext();
        MapNearCacheManager mapNearCacheManager = mapServiceContext.getMapNearCacheManager();
        Invalidator invalidator = mapNearCacheManager.getInvalidator();
        return invalidator.getMetaDataGenerator();
    }

    private void writeWriteBehindState(ObjectDataOutput out, RecordStore recordStore) throws IOException {
        MapContainer mapContainer = recordStore.getMapContainer();
        MapConfig mapConfig = mapContainer.getMapConfig();
        if (mapConfig.getTotalBackupCount() < this.getReplicaIndex() || !mapContainer.getMapStoreContext().isWriteBehindMapStoreEnabled()) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        MapServiceContext mapServiceContext = recordStore.getMapContainer().getMapServiceContext();
        WriteBehindStore mapDataStore = (WriteBehindStore)recordStore.getMapDataStore();
        List<DelayedEntry> delayedEntries = mapDataStore.getWriteBehindQueue().asList();
        out.writeInt(delayedEntries.size());
        for (DelayedEntry delayedEntry : delayedEntries) {
            Data key = mapServiceContext.toData(delayedEntry.getKey());
            Data value = mapServiceContext.toData(delayedEntry.getValue());
            long expirationTime = delayedEntry.getExpirationTime();
            IOUtil.writeData(out, key);
            IOUtil.writeData(out, value);
            out.writeLong(expirationTime);
            out.writeLong(delayedEntry.getStoreTime());
            out.writeInt(delayedEntry.getPartitionId());
            out.writeLong(delayedEntry.getSequence());
            UUIDSerializationUtil.writeUUID(out, delayedEntry.getTxnId());
        }
        ArrayDeque<WriteBehindStore.Sequence> sequences = new ArrayDeque<WriteBehindStore.Sequence>(mapDataStore.getFlushSequences());
        out.writeInt(sequences.size());
        for (WriteBehindStore.Sequence sequence : sequences) {
            out.writeLong(sequence.getSequence());
            out.writeBoolean(sequence.isFullFlush());
        }
        Map<UUID, Long> map = mapDataStore.getTxnReservedCapacityCounter().getReservedCapacityCountPerTxnId();
        out.writeInt(map.size());
        for (Map.Entry<UUID, Long> counterByTxnId : map.entrySet()) {
            UUIDSerializationUtil.writeUUID(out, counterByTxnId.getKey());
            out.writeLong(counterByTxnId.getValue());
        }
    }

    protected final void writeChunk(ObjectDataOutput out, MapChunkContext context) throws IOException {
        SerializationService ss = context.getSerializationService();
        long recordCount = 0L;
        out.writeString(context.getMapName());
        Iterator<Map.Entry<Data, Record>> entries = context.getIterator();
        while (entries.hasNext()) {
            Map.Entry<Data, Record> entry = entries.next();
            Data dataKey = entry.getKey();
            Record record = entry.getValue();
            Object dataValue = ss.toData(record.getValue());
            IOUtil.writeData(out, dataKey);
            Records.writeRecord(out, record, dataValue);
            Records.writeExpiry(out, context.getExpiryMetadata(dataKey));
            ++recordCount;
            if (!this.isEndOfChunk.test(out)) continue;
            break;
        }
        this.incrementReplicationRecordCount(recordCount);
        if (!entries.hasNext()) {
            this.incrementReplicationCount();
        }
        IOUtil.writeData(out, null);
    }

    @Override
    protected final void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.firstChunk = in.readBoolean();
        if (this.firstChunk) {
            this.readMetadata(in);
        }
        this.readChunk(in);
        this.lastChunk = in.readBoolean();
    }

    protected void readMetadata(ObjectDataInput in) throws IOException {
        this.mapIndexInfo = (MapIndexInfo)in.readObject();
        this.loaded = in.readBoolean();
        this.stats = new LocalRecordStoreStatsImpl();
        this.stats.readData(in);
        this.readWriteBehindState(in);
        this.readNearCacheState(in);
    }

    private void readWriteBehindState(ObjectDataInput in) throws IOException {
        this.hasWriteBehindState = in.readBoolean();
        if (!this.hasWriteBehindState) {
            return;
        }
        int listSize = in.readInt();
        this.delayedEntriesList = new ArrayList<DelayedEntry>(listSize);
        for (int j = 0; j < listSize; ++j) {
            Data key = IOUtil.readData(in);
            Data value = IOUtil.readData(in);
            long expirationTime = in.readLong();
            long storeTime = in.readLong();
            int partitionId = in.readInt();
            long sequence = in.readLong();
            UUID txnId = UUIDSerializationUtil.readUUID(in);
            DelayedEntry<Data, Data> entry = DelayedEntries.newAddedDelayedEntry(key, value, expirationTime, storeTime, partitionId, txnId);
            entry.setSequence(sequence);
            this.delayedEntriesList.add(entry);
        }
        int setSize = in.readInt();
        this.sequences = new ArrayDeque(setSize);
        for (int j = 0; j < setSize; ++j) {
            this.sequences.add(new WriteBehindStore.Sequence(in.readLong(), in.readBoolean()));
        }
        int numOfCounters = in.readInt();
        this.counterByTxnId = MapUtil.createHashMap(numOfCounters);
        for (int j = 0; j < numOfCounters; ++j) {
            this.counterByTxnId.put(UUIDSerializationUtil.readUUID(in), in.readLong());
        }
    }

    private void readChunk(ObjectDataInput in) throws IOException {
        Data dataKey;
        this.mapName = in.readString();
        LinkedList<Object> keyRecordExpiry = new LinkedList<Object>();
        while ((dataKey = IOUtil.readData(in)) != null) {
            Record record = Records.readRecord(in);
            ExpiryMetadata expiryMetadata = Records.readExpiry(in);
            keyRecordExpiry.add(dataKey);
            keyRecordExpiry.add(record);
            keyRecordExpiry.add(expiryMetadata);
        }
        this.keyRecordExpiry = keyRecordExpiry;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 158;
    }
}

