/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConcurrentReferenceHashMap;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggerFactory;
import com.hazelcast.logging.impl.InternalLogger;
import com.hazelcast.logging.impl.InternalLoggerFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public abstract class LoggerFactorySupport
implements LoggerFactory,
InternalLoggerFactory {
    final ConcurrentMap<String, ILogger> mapLoggers = new ConcurrentHashMap<String, ILogger>(100);
    final ConstructorFunction<String, ILogger> loggerConstructor = this::createLogger;
    final ConcurrentMap<ILogger, Optional<Level>> levels = new ConcurrentReferenceHashMap<ILogger, Optional<Level>>(100);

    @Override
    public final ILogger getLogger(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.mapLoggers, name, this.loggerConstructor);
    }

    protected abstract ILogger createLogger(String var1);

    public void clearLoadedLoggers() {
        this.mapLoggers.clear();
        this.levels.clear();
    }

    @Override
    public void setLevel(@Nonnull Level level) {
        for (ILogger logger2 : this.mapLoggers.values()) {
            Optional currentLevel = this.levels.computeIfAbsent(logger2, l -> level == Level.OFF || l.isLoggable(level) ? null : Optional.ofNullable(l.getLevel()));
            if (currentLevel == null) continue;
            this.obtainInternalLogger(logger2).setLevel(level);
        }
    }

    @Override
    public void resetLevel() {
        Iterator iterator2 = this.levels.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            ILogger logger2 = (ILogger)entry.getKey();
            Level level = ((Optional)entry.getValue()).orElse(null);
            this.obtainInternalLogger(logger2).setLevel(level);
            iterator2.remove();
        }
    }

    private InternalLogger obtainInternalLogger(ILogger logger2) {
        if (logger2 instanceof InternalLogger) {
            return (InternalLogger)((Object)logger2);
        }
        throw new HazelcastException("Logger doesn't support dynamic log level changes: " + logger2.getClass());
    }
}

