/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.client.impl.protocol.ClientExceptionFactory;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JobAlreadyExistsException;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.core.JobNotFoundException;
import com.hazelcast.jet.core.TopologyChangedException;
import com.hazelcast.jet.datamodel.Tuple3;
import com.hazelcast.jet.impl.exception.CancellationByUserException;
import com.hazelcast.jet.impl.exception.EnteringPassiveClusterStateException;
import com.hazelcast.jet.impl.exception.JetDisabledException;
import com.hazelcast.jet.impl.exception.JobTerminateRequestedException;
import com.hazelcast.jet.impl.exception.TerminatedWithSnapshotException;
import com.hazelcast.jet.impl.execution.TaskletExecutionException;
import com.hazelcast.jet.impl.operation.InitExecutionOperation;
import com.hazelcast.jet.impl.operation.StartExecutionOperation;
import com.hazelcast.jet.pipeline.test.AssertionCompletedException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.sql.impl.ResultLimitReachedException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExceptionUtil {
    private static final List<Tuple3<Integer, Class<? extends Throwable>, ClientExceptionFactory.ExceptionFactory>> EXCEPTIONS = Arrays.asList(Tuple3.tuple3(500, JetException.class, JetException::new), Tuple3.tuple3(501, TopologyChangedException.class, TopologyChangedException::new), Tuple3.tuple3(502, JobNotFoundException.class, JobNotFoundException::new), Tuple3.tuple3(503, JobAlreadyExistsException.class, JobAlreadyExistsException::new), Tuple3.tuple3(504, AssertionCompletedException.class, AssertionCompletedException::new), Tuple3.tuple3(505, JetDisabledException.class, JetDisabledException::new), Tuple3.tuple3(506, CancellationByUserException.class, CancellationByUserException::new), Tuple3.tuple3(507, TaskletExecutionException.class, TaskletExecutionException::new));

    private ExceptionUtil() {
    }

    public static boolean isRestartableException(Throwable t2) {
        return ExceptionUtil.isTopologyException(t2) || t2 instanceof RestartableException || t2 instanceof JetException && ExceptionUtil.isOrHasCause(t2, RestartableException.class) || t2 instanceof CompletionException && ExceptionUtil.isOrHasCause(t2, RestartableException.class);
    }

    public static boolean isTopologyException(Throwable t2) {
        return t2 instanceof TopologyChangedException || t2 instanceof MemberLeftException || t2 instanceof TargetNotMemberException || t2 instanceof HazelcastInstanceNotActiveException || t2 instanceof EnteringPassiveClusterStateException || t2 instanceof OperationTimeoutException && (t2.getMessage().contains(InitExecutionOperation.class.getSimpleName()) || t2.getMessage().contains(StartExecutionOperation.class.getSimpleName()));
    }

    public static void registerJetExceptions(@Nonnull ClientExceptionFactory factory2) {
        for (Tuple3<Integer, Class<? extends Throwable>, ClientExceptionFactory.ExceptionFactory> exception : EXCEPTIONS) {
            factory2.register(exception.f0(), exception.f1(), exception.f2());
        }
    }

    public static Throwable peel(@Nullable Throwable t2) {
        while ((t2 instanceof CompletionException || t2 instanceof ExecutionException || t2 instanceof InvocationTargetException) && t2.getCause() != null && t2.getCause() != t2) {
            t2 = t2.getCause();
        }
        return t2;
    }

    @Nonnull
    private static RuntimeException peeledAndUnchecked(@Nonnull Throwable t2) {
        if ((t2 = ExceptionUtil.peel(t2)) instanceof RuntimeException) {
            return (RuntimeException)t2;
        }
        return new JetException(t2);
    }

    @Nonnull
    public static RuntimeException rethrow(@Nonnull Throwable t2) {
        if (t2 instanceof Error) {
            if (t2 instanceof OutOfMemoryError) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)t2);
            }
            throw (Error)t2;
        }
        throw ExceptionUtil.peeledAndUnchecked(t2);
    }

    @Nonnull
    public static <T> BiConsumer<T, ? super Throwable> withTryCatch(@Nonnull ILogger logger2, @Nonnull BiConsumer<T, ? super Throwable> consumer) {
        return ExceptionUtil.withTryCatch(logger2, "Exception during callback", consumer);
    }

    @Nonnull
    public static <T> BiConsumer<T, ? super Throwable> withTryCatch(@Nonnull ILogger logger2, @Nonnull String message, @Nonnull BiConsumer<T, ? super Throwable> consumer) {
        return (r, t2) -> {
            try {
                consumer.accept((Object)r, (Throwable)t2);
            }
            catch (Throwable e) {
                logger2.severe(message, e);
            }
        };
    }

    @Nonnull
    public static <T extends Throwable> RuntimeException sneakyThrow(@Nonnull Throwable t2) throws T {
        throw t2;
    }

    @Nonnull
    public static String stackTraceToString(Throwable t2) {
        StringWriter sw = new StringWriter();
        t2.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static RuntimeException handleSerializedLambdaCce(HazelcastSerializationException e) {
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ClassCastException) || !cause.getMessage().startsWith("cannot assign instance of java.lang.invoke.SerializedLambda")) continue;
            throw new JetException("Class containing the lambda probably missing from class path, did you add it using JobConfig.addClass()?: " + e, e);
        }
        throw e;
    }

    public static boolean isOrHasCause(Throwable t2, Class<?> classToFind) {
        while (t2 != null && t2.getCause() != t2 && !classToFind.isAssignableFrom(t2.getClass())) {
            t2 = t2.getCause();
        }
        return t2 != null && classToFind.isAssignableFrom(t2.getClass());
    }

    public static boolean isTechnicalCancellationException(Throwable t2) {
        Throwable peeledFailure = ExceptionUtil.peel(t2);
        return peeledFailure instanceof JobTerminateRequestedException || peeledFailure instanceof ResultLimitReachedException || peeledFailure instanceof TerminatedWithSnapshotException || ExceptionUtil.checkCause(peeledFailure);
    }

    private static boolean checkCause(Throwable peeledFailure) {
        return peeledFailure.getCause() != null && peeledFailure != peeledFailure.getCause() && ExceptionUtil.isTechnicalCancellationException(peeledFailure.getCause());
    }
}

