/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.processor;

import com.hazelcast.function.ConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.logging.ILogger;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class TwoPhaseSnapshotCommitUtility<TXN_ID extends TransactionId, RES extends TransactionalResource<TXN_ID>>
implements AutoCloseable {
    private final boolean isSource;
    private final Outbox outbox;
    private final Processor.Context procContext;
    private final ProcessingGuarantee externalGuarantee;
    private final FunctionEx<TXN_ID, LoggingNonThrowingResource<TXN_ID, RES>> createTxnFn;
    private final Consumer<TXN_ID> recoverAndCommitFn;
    private final ConsumerEx<Integer> recoverAndAbortFn;

    protected TwoPhaseSnapshotCommitUtility(@Nonnull Outbox outbox, @Nonnull Processor.Context procContext, boolean isSource, @Nonnull ProcessingGuarantee externalGuarantee, @Nonnull FunctionEx<TXN_ID, RES> createTxnFn, @Nonnull ConsumerEx<TXN_ID> recoverAndCommitFn, @Nonnull ConsumerEx<Integer> recoverAndAbortFn) {
        if (externalGuarantee.ordinal() > procContext.processingGuarantee().ordinal()) {
            throw new IllegalArgumentException("unsupported combination, job guarantee cannot by lower than external guarantee. Job guarantee: " + (Object)((Object)procContext.processingGuarantee()) + ", external guarantee: " + (Object)((Object)externalGuarantee));
        }
        this.isSource = isSource;
        this.outbox = outbox;
        this.procContext = procContext;
        this.externalGuarantee = externalGuarantee;
        this.createTxnFn = txnId -> new LoggingNonThrowingResource(procContext.logger(), (TransactionalResource)createTxnFn.apply(txnId), null);
        this.recoverAndCommitFn = recoverAndCommitFn;
        this.recoverAndAbortFn = recoverAndAbortFn;
    }

    public ProcessingGuarantee externalGuarantee() {
        return this.externalGuarantee;
    }

    protected Outbox getOutbox() {
        return this.outbox;
    }

    protected Processor.Context procContext() {
        return this.procContext;
    }

    protected FunctionEx<TXN_ID, LoggingNonThrowingResource<TXN_ID, RES>> createTxnFn() {
        return this.createTxnFn;
    }

    protected Consumer<TXN_ID> recoverAndCommitFn() {
        return this.recoverAndCommitFn;
    }

    protected ConsumerEx<Integer> recoverAndAbortFn() {
        return this.recoverAndAbortFn;
    }

    public boolean tryProcess() {
        return true;
    }

    @Nullable
    public abstract RES activeTransaction();

    public abstract void afterCompleted();

    public abstract boolean snapshotCommitPrepare();

    public abstract boolean snapshotCommitFinish(boolean var1);

    public void restoreFromSnapshot(@Nonnull Inbox inbox) {
        Object item;
        while ((item = inbox.poll()) != null) {
            Map.Entry castedItem = (Map.Entry)item;
            this.restoreFromSnapshot(castedItem.getKey(), castedItem.getValue());
        }
    }

    public abstract void restoreFromSnapshot(@Nonnull Object var1, @Nonnull Object var2);

    @Override
    public abstract void close() throws Exception;

    public boolean usesTransactionLifecycle() {
        return this.externalGuarantee == ProcessingGuarantee.EXACTLY_ONCE || this.externalGuarantee == ProcessingGuarantee.AT_LEAST_ONCE && this.isSource;
    }

    protected static final class LoggingNonThrowingResource<TXN_ID, RES extends TransactionalResource<TXN_ID>>
    implements TransactionalResource<TXN_ID> {
        private final ILogger logger;
        private final RES wrapped;

        private LoggingNonThrowingResource(ILogger logger2, RES wrapped) {
            this.logger = logger2;
            this.wrapped = wrapped;
        }

        public RES wrapped() {
            return this.wrapped;
        }

        @Override
        public TXN_ID id() {
            return this.wrapped.id();
        }

        @Override
        public void begin() {
            LoggingUtil.logFine(this.logger, "begin %s", this.id());
            try {
                this.wrapped.begin();
            }
            catch (Exception e) {
                throw ExceptionUtil.sneakyThrow(e);
            }
        }

        @Override
        public boolean flush() {
            LoggingUtil.logFine(this.logger, "flush %s", this.id());
            try {
                return this.wrapped.flush();
            }
            catch (Exception e) {
                throw ExceptionUtil.sneakyThrow(e);
            }
        }

        @Override
        public void endAndPrepare() {
            LoggingUtil.logFine(this.logger, "endAndPrepare %s", this.id());
            try {
                this.wrapped.endAndPrepare();
            }
            catch (Exception e) {
                throw ExceptionUtil.sneakyThrow(e);
            }
        }

        @Override
        public void commit() {
            LoggingUtil.logFine(this.logger, "commit %s", this.id());
            try {
                this.wrapped.commit();
            }
            catch (Exception e) {
                throw ExceptionUtil.sneakyThrow(e);
            }
        }

        @Override
        public void rollback() {
            LoggingUtil.logFine(this.logger, "rollback %s", this.id());
            try {
                this.wrapped.rollback();
            }
            catch (Exception e) {
                throw ExceptionUtil.sneakyThrow(e);
            }
        }

        @Override
        public void release() {
            LoggingUtil.logFine(this.logger, "release %s", this.id());
            try {
                this.wrapped.release();
            }
            catch (Exception e) {
                throw ExceptionUtil.sneakyThrow(e);
            }
        }

        /* synthetic */ LoggingNonThrowingResource(ILogger x0, TransactionalResource x1, 1 x2) {
            this(x0, x1);
        }
    }

    public static interface TransactionId {
        public int index();
    }

    public static interface TransactionalResource<TXN_ID> {
        public TXN_ID id();

        default public void begin() throws Exception {
            throw new UnsupportedOperationException("Resource without transaction support");
        }

        default public boolean flush() throws Exception {
            return true;
        }

        default public void endAndPrepare() throws Exception {
        }

        default public void commit() throws Exception {
            throw new UnsupportedOperationException();
        }

        default public void rollback() throws Exception {
        }

        default public void release() throws Exception {
        }
    }
}

