/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.dataconnection.DataConnectionService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.config.ResourceConfig;
import com.hazelcast.jet.config.ResourceType;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.JobRepository;
import com.hazelcast.jet.impl.deployment.IMapInputStream;
import com.hazelcast.jet.impl.metrics.MetricsContext;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.IOUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.IMap;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.Permission;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;

public final class Contexts {
    private static final ThreadLocal<Container> CONTEXT = ThreadLocal.withInitial(Container::new);

    private Contexts() {
    }

    public static Container container() {
        return CONTEXT.get();
    }

    @Nonnull
    public static Processor.Context getThreadContext() {
        Container container = CONTEXT.get();
        Processor.Context context = container.getContext();
        if (context == null) {
            throw new RuntimeException("Thread %s has no context set, this method can be called only on threads executing the job's processors");
        }
        return context;
    }

    @Nonnull
    public static ProcCtx getCastedThreadContext() {
        Processor.Context c = Contexts.getThreadContext();
        if (!(c instanceof ProcCtx)) {
            throw new RuntimeException("No real processor context - metrics not available");
        }
        return (ProcCtx)c;
    }

    public static class Container {
        @Nullable
        private Processor.Context context;

        Container() {
        }

        @Nullable
        public Processor.Context getContext() {
            return this.context;
        }

        public void setContext(@Nullable Processor.Context context) {
            this.context = context;
        }
    }

    public static class ProcCtx
    extends ProcSupplierCtx
    implements Processor.Context {
        private final int localProcessorIndex;
        private final int globalProcessorIndex;
        private final MetricsContext metricsContext = new MetricsContext();

        public ProcCtx(NodeEngineImpl nodeEngine, long jobId, long executionId, JobConfig jobConfig, ILogger logger2, String vertexName, int localProcessorIndex, int globalProcessorIndex, boolean isLightJob, Map<Address, int[]> partitionAssignment, int localParallelism, int memberIndex, int memberCount, ConcurrentHashMap<String, File> tempDirectories, InternalSerializationService serializationService, Subject subject, ClassLoader classLoader) {
            super(nodeEngine, jobId, executionId, jobConfig, logger2, vertexName, localParallelism, memberCount * localParallelism, memberIndex, memberCount, isLightJob, partitionAssignment, tempDirectories, serializationService, subject, classLoader);
            this.localProcessorIndex = localProcessorIndex;
            this.globalProcessorIndex = globalProcessorIndex;
        }

        @Override
        public int localProcessorIndex() {
            return this.localProcessorIndex;
        }

        @Override
        public int globalProcessorIndex() {
            return this.globalProcessorIndex;
        }

        public MetricsContext metricsContext() {
            return this.metricsContext;
        }
    }

    public static class ProcSupplierCtx
    extends MetaSupplierCtx
    implements ProcessorSupplier.Context {
        private final int memberIndex;
        private final ConcurrentHashMap<String, File> tempDirectories;
        private final InternalSerializationService serializationService;

        ProcSupplierCtx(NodeEngineImpl nodeEngine, long jobId, long executionId, JobConfig jobConfig, ILogger logger2, String vertexName, int localParallelism, int totalParallelism, int memberIndex, int memberCount, boolean isLightJob, Map<Address, int[]> partitionAssignment, ConcurrentHashMap<String, File> tempDirectories, InternalSerializationService serializationService, Subject subject, ClassLoader classLoader) {
            super(nodeEngine, jobId, executionId, jobConfig, logger2, vertexName, localParallelism, totalParallelism, memberCount, isLightJob, partitionAssignment, subject, classLoader);
            this.memberIndex = memberIndex;
            this.tempDirectories = tempDirectories;
            this.serializationService = serializationService;
        }

        @Override
        public int memberIndex() {
            return this.memberIndex;
        }

        @Override
        @Nonnull
        public File attachedDirectory(@Nonnull String id) {
            Preconditions.checkHasText(id, "id cannot be null or empty");
            ResourceConfig resourceConfig = this.jobConfig().getResourceConfigs().get(id);
            if (resourceConfig == null) {
                throw new JetException(String.format("No resource is attached with ID '%s'", id));
            }
            if (resourceConfig.getResourceType() != ResourceType.DIRECTORY) {
                throw new JetException(String.format("The resource with ID '%s' is not a directory, its type is %s", new Object[]{id, resourceConfig.getResourceType()}));
            }
            return this.tempDirectories.computeIfAbsent(id, x -> this.extractFileToDisk(id, null));
        }

        @Override
        @Nonnull
        public File recreateAttachedDirectory(@Nonnull String id) {
            this.recreateIfExists(id);
            return this.attachedDirectory(id);
        }

        @Override
        @Nonnull
        public File attachedFile(@Nonnull String id) {
            Preconditions.checkHasText(id, "id cannot be null or empty");
            ResourceConfig resourceConfig = this.jobConfig().getResourceConfigs().get(id);
            if (resourceConfig == null) {
                throw new JetException(String.format("No resource is attached with ID '%s'", id));
            }
            if (resourceConfig.getResourceType() != ResourceType.FILE) {
                throw new JetException(String.format("The resource with ID '%s' is not a file, its type is %s", new Object[]{id, resourceConfig.getResourceType()}));
            }
            String fnamePath = Objects.requireNonNull(IOUtil.fileNameFromUrl(resourceConfig.getUrl()));
            return new File(this.tempDirectories.computeIfAbsent(id, x -> this.extractFileToDisk(id, null)), fnamePath);
        }

        @Override
        @Nonnull
        public File recreateAttachedFile(@Nonnull String id) {
            this.recreateIfExists(id);
            return this.attachedFile(id);
        }

        public ConcurrentHashMap<String, File> tempDirectories() {
            return this.tempDirectories;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private File extractFileToDisk(@Nonnull String id, @Nullable File destFile) {
            IMap<String, byte[]> map = this.hazelcastInstance().getMap(JobRepository.jobResourcesMapName(this.jobId()));
            try (IMapInputStream inputStream2 = new IMapInputStream(map, JobRepository.fileKeyName(id));){
                Path destPath = destFile == null ? Files.createTempDirectory(ProcSupplierCtx.tempDirPrefix(this.hazelcastInstance().getName(), Util.idToString(this.jobId()), id), new FileAttribute[0]) : destFile.toPath();
                IOUtil.unzip(inputStream2, destPath);
                File file = destPath.toFile();
                return file;
            }
            catch (IOException e) {
                throw ExceptionUtil.rethrow(e);
            }
        }

        private void recreateIfExists(@Nonnull String id) {
            File dirFile = this.tempDirectories.get(id);
            if (dirFile == null) {
                return;
            }
            try {
                List<String> filesNotMarked = com.hazelcast.jet.impl.util.Util.editPermissionsRecursively(dirFile.toPath(), perms -> perms.add(PosixFilePermission.OWNER_WRITE));
                if (!filesNotMarked.isEmpty()) {
                    this.logger().info("Couldn't 'chmod u+w' these files: " + filesNotMarked);
                }
                for (File file : Objects.requireNonNull(dirFile.listFiles())) {
                    com.hazelcast.internal.nio.IOUtil.delete(file);
                }
                this.extractFileToDisk(id, dirFile);
            }
            catch (IOException e) {
                throw ExceptionUtil.rethrow(e);
            }
        }

        private static String tempDirPrefix(String jetInstanceName, String jobId, String resourceId) {
            return "jet-" + jetInstanceName + "-" + jobId + "-" + resourceId.substring(0, Math.min(32, resourceId.length())).replaceAll("[^\\w.\\-$]", "_");
        }

        @Override
        @Nonnull
        public ManagedContext managedContext() {
            return this.serializationService.getManagedContext();
        }

        @Nonnull
        public InternalSerializationService serializationService() {
            return this.serializationService;
        }
    }

    public static class MetaSupplierCtx
    implements ProcessorMetaSupplier.Context {
        private final NodeEngineImpl nodeEngine;
        private final long jobId;
        private final long executionId;
        private final JobConfig jobConfig;
        private final ILogger logger;
        private final String vertexName;
        private final int localParallelism;
        private final int totalParallelism;
        private final int memberCount;
        private final boolean isLightJob;
        private final Map<Address, int[]> partitionAssignment;
        private final Subject subject;
        private final ClassLoader classLoader;

        MetaSupplierCtx(NodeEngineImpl nodeEngine, long jobId, long executionId, JobConfig jobConfig, ILogger logger2, String vertexName, int localParallelism, int totalParallelism, int memberCount, boolean isLightJob, Map<Address, int[]> partitionAssignment, Subject subject, ClassLoader classLoader) {
            this.nodeEngine = nodeEngine;
            this.jobId = jobId;
            this.executionId = executionId;
            this.jobConfig = jobConfig;
            this.logger = logger2;
            this.vertexName = vertexName;
            this.totalParallelism = totalParallelism;
            this.localParallelism = localParallelism;
            this.memberCount = memberCount;
            this.isLightJob = isLightJob;
            this.partitionAssignment = partitionAssignment;
            this.subject = subject;
            this.classLoader = classLoader;
        }

        public NodeEngineImpl nodeEngine() {
            return this.nodeEngine;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Subject subject() {
            return this.subject;
        }

        @Override
        @Nonnull
        public HazelcastInstance hazelcastInstance() {
            return this.nodeEngine.getHazelcastInstance();
        }

        @Override
        @Nonnull
        @Deprecated
        public JetInstance jetInstance() {
            return (JetInstance)this.hazelcastInstance().getJet();
        }

        @Override
        public long jobId() {
            return this.jobId;
        }

        @Override
        public long executionId() {
            return this.executionId;
        }

        @Override
        @Nonnull
        public JobConfig jobConfig() {
            return this.jobConfig;
        }

        @Override
        public int totalParallelism() {
            return this.totalParallelism;
        }

        @Override
        public int localParallelism() {
            return this.localParallelism;
        }

        @Override
        public int memberCount() {
            return this.memberCount;
        }

        @Override
        @Nonnull
        public String vertexName() {
            return this.vertexName;
        }

        @Override
        @Nonnull
        public ILogger logger() {
            return this.logger;
        }

        @Override
        public ProcessingGuarantee processingGuarantee() {
            return this.jobConfig.getProcessingGuarantee();
        }

        @Override
        public long maxProcessorAccumulatedRecords() {
            long jobMaxProcessorAccumulatedRecords = this.jobConfig.getMaxProcessorAccumulatedRecords();
            return jobMaxProcessorAccumulatedRecords > -1L ? jobMaxProcessorAccumulatedRecords : this.hazelcastInstance().getConfig().getJetConfig().getMaxProcessorAccumulatedRecords();
        }

        @Override
        public boolean isLightJob() {
            return this.isLightJob;
        }

        @Override
        public Map<Address, int[]> partitionAssignment() {
            return this.partitionAssignment;
        }

        @Override
        public ClassLoader classLoader() {
            return this.classLoader;
        }

        @Override
        public DataConnectionService dataConnectionService() {
            return this.nodeEngine().getDataConnectionService();
        }

        @Override
        public void checkPermission(@Nonnull Permission permission) {
            if (this.subject == null) {
                return;
            }
            SecurityContext securityContext = this.nodeEngine.getNode().securityContext;
            if (securityContext == null) {
                return;
            }
            securityContext.checkPermission(this.subject, permission);
        }
    }
}

