/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.test;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.DataConnectionService;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.instance.impl.HazelcastInstanceProxy;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.jet.JetInstance;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.execution.init.ExecutionPlanBuilder;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class TestProcessorMetaSupplierContext
implements ProcessorMetaSupplier.Context {
    protected ILogger logger;
    private HazelcastInstance instance;
    private long jobId = 1L;
    private long executionId = 1L;
    private JobConfig jobConfig = new JobConfig();
    private int totalParallelism = 1;
    private int localParallelism = 1;
    private String vertexName = "testVertex";
    private ProcessingGuarantee processingGuarantee = ProcessingGuarantee.NONE;
    private long maxProcessorAccumulatedRecords = Long.MAX_VALUE;
    private boolean isLightJob;
    private Map<Address, int[]> partitionAssignment = Collections.unmodifiableMap(new HashMap<Address, int[]>(){
        {
            try {
                this.put(new Address("1.2.3.4", 1), new int[]{0});
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
    });
    private ClassLoader classLoader;

    @Override
    @Nonnull
    public HazelcastInstance hazelcastInstance() {
        return this.instance;
    }

    @Override
    @Nonnull
    @Deprecated
    public JetInstance jetInstance() {
        return (JetInstance)this.instance.getJet();
    }

    @Nonnull
    public TestProcessorMetaSupplierContext setHazelcastInstance(@Nonnull HazelcastInstance instance) {
        this.instance = instance;
        if (this.instance instanceof HazelcastInstanceProxy || this.instance instanceof HazelcastInstanceImpl) {
            NodeEngineImpl nodeEngine = Util.getNodeEngine(this.instance);
            this.partitionAssignment = ExecutionPlanBuilder.getPartitionAssignment(nodeEngine, Util.getMembersView(nodeEngine).getMembers()).entrySet().stream().collect(Collectors.toMap(en -> ((MemberInfo)en.getKey()).getAddress(), Map.Entry::getValue));
        }
        return this;
    }

    @Override
    public long jobId() {
        return this.jobId;
    }

    public TestProcessorMetaSupplierContext setJobId(long jobId) {
        this.jobId = jobId;
        return this;
    }

    @Override
    public long executionId() {
        return this.executionId;
    }

    public TestProcessorMetaSupplierContext setExecutionId(long executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    @Nonnull
    public JobConfig jobConfig() {
        return this.jobConfig;
    }

    public TestProcessorMetaSupplierContext setJobConfig(@Nonnull JobConfig jobConfig) {
        this.jobConfig = jobConfig;
        return this;
    }

    @Override
    public int totalParallelism() {
        return this.totalParallelism;
    }

    @Nonnull
    public TestProcessorMetaSupplierContext setTotalParallelism(int totalParallelism) {
        this.totalParallelism = totalParallelism;
        return this;
    }

    @Override
    public int localParallelism() {
        return this.localParallelism;
    }

    @Nonnull
    public TestProcessorMetaSupplierContext setLocalParallelism(int localParallelism) {
        this.localParallelism = localParallelism;
        return this;
    }

    @Override
    @Nonnull
    public ILogger logger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.loggerName());
        }
        return this.logger;
    }

    public TestProcessorMetaSupplierContext setLogger(@Nonnull ILogger logger2) {
        this.logger = logger2;
        return this;
    }

    @Override
    public int memberCount() {
        return this.totalParallelism() / this.localParallelism();
    }

    @Override
    @Nonnull
    public String vertexName() {
        return this.vertexName;
    }

    @Nonnull
    public TestProcessorMetaSupplierContext setVertexName(@Nonnull String vertexName) {
        this.vertexName = vertexName;
        return this;
    }

    protected String loggerName() {
        return this.vertexName() + "#PMS";
    }

    @Override
    public ProcessingGuarantee processingGuarantee() {
        return this.processingGuarantee;
    }

    @Nonnull
    public TestProcessorMetaSupplierContext setProcessingGuarantee(@Nonnull ProcessingGuarantee processingGuarantee) {
        this.processingGuarantee = processingGuarantee;
        return this;
    }

    @Override
    public long maxProcessorAccumulatedRecords() {
        return this.maxProcessorAccumulatedRecords;
    }

    public void setMaxProcessorAccumulatedRecords(long maxProcessorAccumulatedRecords) {
        this.maxProcessorAccumulatedRecords = maxProcessorAccumulatedRecords;
    }

    @Override
    public boolean isLightJob() {
        return this.isLightJob;
    }

    @Nonnull
    public TestProcessorMetaSupplierContext setIsLightJob(boolean isLightJob) {
        this.isLightJob = isLightJob;
        return this;
    }

    @Override
    public Map<Address, int[]> partitionAssignment() {
        return this.partitionAssignment;
    }

    @Nonnull
    public TestProcessorMetaSupplierContext setPartitionAssignment(Map<Address, int[]> partitionAssignment) {
        this.partitionAssignment = partitionAssignment;
        return this;
    }

    @Override
    public ClassLoader classLoader() {
        return this.classLoader;
    }

    @Override
    public DataConnectionService dataConnectionService() {
        return Util.getNodeEngine(this.instance).getDataConnectionService();
    }

    @Nonnull
    public TestProcessorMetaSupplierContext setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public void checkPermission(Permission permission) throws AccessControlException {
    }
}

