/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.ComparatorEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.Functions;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.core.DefaultPartitionStrategy;
import com.hazelcast.jet.core.JetDataSerializerHook;
import com.hazelcast.jet.core.Partitioner;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.util.ConstantFunctionEx;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Edge
implements IdentifiedDataSerializable {
    public static final Address DISTRIBUTE_TO_ALL;
    private transient boolean locked;
    private Vertex source;
    private String sourceName;
    private int sourceOrdinal;
    private Vertex destination;
    private String destName;
    private int destOrdinal;
    private int priority;
    private Address distributedTo;
    private Partitioner<?> partitioner;
    private RoutingPolicy routingPolicy = RoutingPolicy.UNICAST;
    private ComparatorEx<?> comparator;
    private EdgeConfig config;

    protected Edge() {
    }

    protected Edge(@Nonnull Vertex source2, int sourceOrdinal, Vertex destination, int destOrdinal) {
        this.source = source2;
        this.sourceName = source2.getName();
        this.sourceOrdinal = sourceOrdinal;
        this.destination = destination;
        this.destName = destination != null ? destination.getName() : null;
        this.destOrdinal = destOrdinal;
    }

    @Nonnull
    public static Edge between(@Nonnull Vertex source2, @Nonnull Vertex destination) {
        return new Edge(source2, 0, destination, 0);
    }

    @Nonnull
    public static Edge from(@Nonnull Vertex source2) {
        return Edge.from(source2, 0);
    }

    @Nonnull
    public static Edge from(@Nonnull Vertex source2, int ordinal) {
        return new Edge(source2, ordinal, null, 0);
    }

    @Nonnull
    public Edge to(@Nonnull Vertex destination) {
        this.throwIfLocked();
        return this.to(destination, 0);
    }

    @Nonnull
    public Edge to(@Nonnull Vertex destination, int ordinal) {
        this.throwIfLocked();
        if (this.destination != null) {
            throw new IllegalStateException("destination already set");
        }
        this.destination = destination;
        this.destName = destination.getName();
        this.destOrdinal = ordinal;
        return this;
    }

    @Nonnull
    public Vertex getSource() {
        return this.source;
    }

    @Nullable
    public Vertex getDestination() {
        return this.destination;
    }

    @Nonnull
    public String getSourceName() {
        return this.sourceName;
    }

    public int getSourceOrdinal() {
        return this.sourceOrdinal;
    }

    @Nullable
    public String getDestName() {
        return this.destName;
    }

    public int getDestOrdinal() {
        return this.destOrdinal;
    }

    @Nonnull
    public Edge priority(int priority) {
        this.throwIfLocked();
        if (priority == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("priority must not be Integer.MIN_VALUE (-2147483648)");
        }
        this.priority = priority;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    @Nonnull
    public Edge unicast() {
        this.throwIfLocked();
        this.routingPolicy = RoutingPolicy.UNICAST;
        return this;
    }

    @Nonnull
    public <T> Edge partitioned(@Nonnull FunctionEx<T, ?> extractKeyFn) {
        this.throwIfLocked();
        if (extractKeyFn instanceof ConstantFunctionEx) {
            return this.allToOne(extractKeyFn.apply(null));
        }
        return this.partitioned(extractKeyFn, Partitioner.defaultPartitioner());
    }

    @Nonnull
    public <T, K> Edge partitioned(@Nonnull FunctionEx<T, K> extractKeyFn, @Nonnull Partitioner<? super K> partitioner) {
        this.throwIfLocked();
        Util.checkSerializable(extractKeyFn, "extractKeyFn");
        Util.checkSerializable(partitioner, "partitioner");
        this.routingPolicy = RoutingPolicy.PARTITIONED;
        this.partitioner = new KeyPartitioner(extractKeyFn, partitioner, this.toDebugString());
        return this;
    }

    @Nonnull
    public Edge allToOne(Object key) {
        this.throwIfLocked();
        return this.partitioned(Functions.wholeItem(), new Single(key));
    }

    @Nonnull
    public Edge broadcast() {
        this.throwIfLocked();
        this.routingPolicy = RoutingPolicy.BROADCAST;
        return this;
    }

    @Nonnull
    public Edge isolated() {
        this.throwIfLocked();
        this.routingPolicy = RoutingPolicy.ISOLATED;
        return this;
    }

    public Edge ordered(@Nonnull ComparatorEx<?> comparator) {
        this.throwIfLocked();
        this.comparator = comparator;
        return this;
    }

    @Nonnull
    public Edge fanout() {
        this.throwIfLocked();
        this.routingPolicy = RoutingPolicy.FANOUT;
        return this;
    }

    @Nullable
    public Partitioner<?> getPartitioner() {
        return this.partitioner;
    }

    @Nullable
    public ComparatorEx<?> getOrderComparator() {
        return this.comparator;
    }

    @Nonnull
    public RoutingPolicy getRoutingPolicy() {
        return this.routingPolicy;
    }

    @Nonnull
    public Edge local() {
        this.throwIfLocked();
        this.distributedTo = null;
        return this;
    }

    public boolean isLocal() {
        return this.distributedTo == null;
    }

    @Nonnull
    public Edge distributed() {
        this.throwIfLocked();
        this.distributedTo = DISTRIBUTE_TO_ALL;
        return this;
    }

    @Nonnull
    public Edge distributeTo(@Nonnull Address targetMember) {
        this.throwIfLocked();
        if (Objects.requireNonNull(targetMember).equals(DISTRIBUTE_TO_ALL)) {
            throw new IllegalArgumentException();
        }
        this.distributedTo = targetMember;
        return this;
    }

    @Nullable
    public Address getDistributedTo() {
        return this.distributedTo;
    }

    public boolean isDistributed() {
        return DISTRIBUTE_TO_ALL.equals(this.distributedTo);
    }

    @Nullable
    public EdgeConfig getConfig() {
        return this.config;
    }

    @Nonnull
    public Edge setConfig(@Nullable EdgeConfig config) {
        this.throwIfLocked();
        this.config = config;
        return this;
    }

    @Nonnull
    public String toString() {
        return this.toDebugString();
    }

    private String toDebugString() {
        StringBuilder b = new StringBuilder();
        if (this.sourceOrdinal == 0 && this.destOrdinal == 0) {
            b.append("between(\"").append(this.sourceName).append("\", \"").append(this.destName).append("\")");
        } else {
            b.append("from(\"").append(this.sourceName).append('\"');
            if (this.sourceOrdinal != 0) {
                b.append(", ").append(this.sourceOrdinal);
            }
            b.append(").to(\"").append(this.destName).append('\"');
            if (this.destOrdinal != 0) {
                b.append(", ").append(this.destOrdinal);
            }
            b.append(')');
        }
        switch (this.getRoutingPolicy()) {
            case UNICAST: {
                break;
            }
            case ISOLATED: {
                b.append(".isolated()");
                break;
            }
            case PARTITIONED: {
                b.append(this.getPartitioner() instanceof Single ? ".allToOne()" : ".partitioned(?)");
                break;
            }
            case BROADCAST: {
                b.append(".broadcast()");
                break;
            }
            case FANOUT: {
                b.append(".fanout()");
                break;
            }
        }
        if (DISTRIBUTE_TO_ALL.equals(this.distributedTo)) {
            b.append(".distributed()");
        } else if (this.distributedTo != null) {
            b.append(".distributeTo(").append(this.distributedTo).append(')');
        }
        if (this.getPriority() != 0) {
            b.append(".priority(").append(this.getPriority()).append(')');
        }
        return b.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Edge)) return false;
        Edge that = (Edge)obj;
        if (!this.sourceName.equals(that.sourceName)) return false;
        if (!this.destName.equals(that.destName)) return false;
        if (this.sourceOrdinal != that.sourceOrdinal) return false;
        if (this.destOrdinal != that.destOrdinal) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.sourceName, this.destName, this.sourceOrdinal, this.destOrdinal);
    }

    void restoreSourceAndDest(Map<String, Vertex> nameToVertex) {
        this.source = nameToVertex.get(this.sourceName);
        this.destination = nameToVertex.get(this.destName);
        assert (this.source != null) : "Couldn't restore source vertex " + this.sourceName + " from map " + nameToVertex;
        assert (this.destination != null) : "Couldn't restore destination vertex " + this.destName + " from map " + nameToVertex;
    }

    @Override
    public void writeData(@Nonnull ObjectDataOutput out) throws IOException {
        out.writeUTF(this.getSourceName());
        out.writeInt(this.getSourceOrdinal());
        out.writeUTF(this.getDestName());
        out.writeInt(this.getDestOrdinal());
        out.writeInt(this.getPriority());
        out.writeObject(this.getDistributedTo());
        out.writeString(this.getRoutingPolicy().name());
        out.writeObject(this.getConfig());
        CustomClassLoadedObject.write(out, this.getPartitioner());
        CustomClassLoadedObject.write(out, this.getOrderComparator());
    }

    @Override
    public void readData(@Nonnull ObjectDataInput in) throws IOException {
        this.sourceName = in.readUTF();
        this.sourceOrdinal = in.readInt();
        this.destName = in.readUTF();
        this.destOrdinal = in.readInt();
        this.priority = in.readInt();
        this.distributedTo = (Address)in.readObject();
        this.routingPolicy = RoutingPolicy.valueOf(in.readString());
        this.config = (EdgeConfig)in.readObject();
        try {
            this.partitioner = (Partitioner)CustomClassLoadedObject.read(in);
            this.comparator = (ComparatorEx)CustomClassLoadedObject.read(in);
        }
        catch (HazelcastSerializationException e) {
            throw new HazelcastSerializationException("Error deserializing edge '" + this.sourceName + "' -> '" + this.destName + "': " + e, e);
        }
    }

    @Override
    public int getFactoryId() {
        return JetDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    private void throwIfLocked() {
        if (this.locked) {
            throw new IllegalStateException("Edge is already locked");
        }
    }

    @PrivateApi
    void lock() {
        this.locked = true;
    }

    static {
        try {
            DISTRIBUTE_TO_ALL = new Address("255.255.255.255", 0);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    static final class KeyPartitioner<T, K>
    implements Partitioner<T>,
    SerializationServiceAware,
    IdentifiedDataSerializable {
        private static final long serialVersionUID = 1L;
        private FunctionEx<T, K> keyExtractor;
        private Partitioner<? super K> partitioner;
        private String edgeDebugName;
        private SerializationService serializationService;

        KeyPartitioner() {
        }

        KeyPartitioner(@Nonnull FunctionEx<T, K> keyExtractor, @Nonnull Partitioner<? super K> partitioner, String edgeDebugName) {
            this.keyExtractor = keyExtractor;
            this.partitioner = partitioner;
            this.edgeDebugName = edgeDebugName;
        }

        @Override
        public void init(@Nonnull DefaultPartitionStrategy strategy) {
            this.partitioner.init(strategy);
            if (this.keyExtractor instanceof SerializationServiceAware) {
                ((SerializationServiceAware)((Object)this.keyExtractor)).setSerializationService(this.serializationService);
            }
        }

        @Override
        public int getPartition(@Nonnull T item, int partitionCount) {
            K key = this.keyExtractor.apply(item);
            if (key == null) {
                throw new JetException("Null key from key extractor, edge: " + this.edgeDebugName);
            }
            return this.partitioner.getPartition(key, partitionCount);
        }

        @Override
        public void setSerializationService(SerializationService serializationService) {
            this.serializationService = serializationService;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject(this.keyExtractor);
            out.writeObject(this.partitioner);
            out.writeString(this.edgeDebugName);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.keyExtractor = (FunctionEx)in.readObject();
            this.partitioner = (Partitioner)in.readObject();
            this.edgeDebugName = in.readString();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 17;
        }
    }

    static class Single
    implements Partitioner<Object>,
    IdentifiedDataSerializable {
        private static final long serialVersionUID = 1L;
        private Object key;
        private int partition;

        Single() {
        }

        Single(Object key) {
            this.key = key;
        }

        @Override
        public void init(@Nonnull DefaultPartitionStrategy strategy) {
            this.partition = strategy.getPartition(this.key);
        }

        @Override
        public int getPartition(@Nonnull Object item, int partitionCount) {
            return this.partition;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject(this.key);
            out.writeInt(this.partition);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            this.key = in.readObject();
            this.partition = in.readInt();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 18;
        }
    }

    public static enum RoutingPolicy implements Serializable
    {
        UNICAST,
        ISOLATED,
        PARTITIONED,
        BROADCAST,
        FANOUT;

    }
}

