/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.Traverser;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class Traversers {
    private static final Traverser<Object> EMPTY_TRAVERSER = new EmptyTraverser<Object>();

    private Traversers() {
    }

    @Nonnull
    public static <T> Traverser<T> empty() {
        return EMPTY_TRAVERSER;
    }

    @Nonnull
    public static <T> Traverser<T> singleton(@Nonnull T item) {
        return new SingletonTraverser<T>(item);
    }

    @Nonnull
    public static <T> Traverser<T> traverseIterator(@Nonnull Iterator<? extends T> iterator2) {
        return () -> iterator2.hasNext() ? Objects.requireNonNull(iterator2.next(), "Iterator returned a null item") : null;
    }

    @Nonnull
    public static <T> Traverser<T> traverseIterator(@Nonnull Iterator<? extends T> iterator2, boolean ignoreNulls) {
        if (!ignoreNulls) {
            return Traversers.traverseIterator(iterator2);
        }
        return () -> {
            while (iterator2.hasNext()) {
                Object next = iterator2.next();
                if (next == null) continue;
                return next;
            }
            return null;
        };
    }

    @Nonnull
    public static <T> Traverser<T> traverseSpliterator(@Nonnull Spliterator<T> spliterator) {
        return new SpliteratorTraverser<T>(spliterator);
    }

    @Nonnull
    public static <T> Traverser<T> traverseEnumeration(@Nonnull Enumeration<T> enumeration) {
        return () -> enumeration.hasMoreElements() ? Objects.requireNonNull(enumeration.nextElement(), "Enumeration contains a null element") : null;
    }

    @Nonnull
    public static <T> Traverser<T> traverseStream(@Nonnull Stream<T> stream) {
        return Traversers.traverseSpliterator(stream.spliterator()).onFirstNull(stream::close);
    }

    @Nonnull
    public static <T> Traverser<T> traverseIterable(@Nonnull Iterable<? extends T> iterable) {
        return Traversers.traverseIterator(iterable.iterator());
    }

    @Nonnull
    public static <T> Traverser<T> traverseArray(@Nonnull T[] array) {
        return new ArrayTraverser<T>(array);
    }

    @SafeVarargs
    public static <T> Traverser<T> traverseItems(T ... items) {
        return Traversers.traverseArray(items);
    }

    @Nonnull
    public static <T> Traverser<T> lazy(@Nonnull Supplier<Traverser<T>> supplierOfTraverser) {
        return new LazyTraverser<T>(supplierOfTraverser);
    }

    private static final class SingletonTraverser<T>
    implements Traverser<T> {
        private T item;

        SingletonTraverser(@Nonnull T item) {
            this.item = item;
        }

        @Override
        public T next() {
            try {
                T t2 = this.item;
                return t2;
            }
            finally {
                this.item = null;
            }
        }

        @Override
        @Nonnull
        public <R> Traverser<R> map(@Nonnull Function<? super T, ? extends R> mapFn) {
            SingletonTraverser newThis = this;
            if (this.item != null) {
                newThis.item = mapFn.apply(this.item);
            }
            return newThis;
        }
    }

    private static final class EmptyTraverser<T>
    implements Traverser<T> {
        private EmptyTraverser() {
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        @Nonnull
        public <R> Traverser<R> map(@Nonnull Function<? super T, ? extends R> mapFn) {
            return this;
        }

        @Override
        @Nonnull
        public <R> Traverser<R> flatMap(@Nonnull Function<? super T, ? extends Traverser<R>> flatMapFn) {
            return this;
        }

        @Override
        @Nonnull
        public Traverser<T> filter(@Nonnull Predicate<? super T> filterFn) {
            return this;
        }

        @Override
        @Nonnull
        public Traverser<T> takeWhile(@Nonnull Predicate<? super T> predicate) {
            return this;
        }

        @Override
        @Nonnull
        public Traverser<T> dropWhile(@Nonnull Predicate<? super T> predicate) {
            return this;
        }

        @Override
        @Nonnull
        public Traverser<T> peek(@Nonnull Consumer<? super T> action) {
            return this;
        }
    }

    private static class SpliteratorTraverser<T>
    implements Traverser<T>,
    Consumer<T> {
        private final Spliterator<T> spliterator;
        private T nextItem;

        SpliteratorTraverser(Spliterator<T> spliterator) {
            this.spliterator = spliterator;
        }

        @Override
        public T next() {
            try {
                boolean advanced = this.spliterator.tryAdvance(this);
                if (advanced) {
                    Objects.requireNonNull(this.nextItem);
                }
                T t2 = this.nextItem;
                return t2;
            }
            finally {
                this.nextItem = null;
            }
        }

        @Override
        public void accept(T t2) {
            this.nextItem = t2;
        }
    }

    private static class ArrayTraverser<T>
    implements Traverser<T> {
        private int index;
        private final T[] array;

        ArrayTraverser(@Nonnull T[] array) {
            this.array = array;
        }

        @Override
        public T next() {
            while (this.index < this.array.length) {
                try {
                    T t2 = this.array[this.index];
                    if (t2 == null) continue;
                    T t3 = t2;
                    return t3;
                }
                finally {
                    ++this.index;
                }
            }
            return null;
        }
    }

    private static final class LazyTraverser<T>
    implements Traverser<T> {
        private Supplier<Traverser<T>> supplierOfTraverser;
        private Traverser<T> traverser;

        LazyTraverser(@Nonnull Supplier<Traverser<T>> supplierOfTraverser) {
            this.supplierOfTraverser = supplierOfTraverser;
        }

        @Override
        public T next() {
            Traverser<T> trav = this.traverser;
            if (trav != null) {
                return trav.next();
            }
            try {
                this.traverser = this.supplierOfTraverser.get();
                T t2 = this.traverser.next();
                return t2;
            }
            finally {
                this.supplierOfTraverser = null;
            }
        }
    }
}

