/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.impl.util.FlatMappingTraverser;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface Traverser<T> {
    public T next();

    @Nonnull
    @CheckReturnValue
    default public <R> Traverser<R> map(@Nonnull Function<? super T, ? extends R> mapFn) {
        return () -> {
            T t2;
            while ((t2 = this.next()) != null) {
                Object r = mapFn.apply((T)t2);
                if (r == null) continue;
                return r;
            }
            return null;
        };
    }

    @Nonnull
    @CheckReturnValue
    default public Traverser<T> filter(@Nonnull Predicate<? super T> filterFn) {
        return () -> {
            T t2;
            while ((t2 = this.next()) != null) {
                if (!filterFn.test((T)t2)) continue;
                return t2;
            }
            return null;
        };
    }

    @Nonnull
    @CheckReturnValue
    default public <R> Traverser<R> flatMap(@Nonnull Function<? super T, ? extends Traverser<R>> flatMapFn) {
        return new FlatMappingTraverser(this, flatMapFn);
    }

    @Nonnull
    @CheckReturnValue
    default public Traverser<T> takeWhile(final @Nonnull Predicate<? super T> predicate) {
        return new Traverser<T>(){
            boolean predicateSatisfied = true;

            @Override
            public T next() {
                if (!this.predicateSatisfied) {
                    return null;
                }
                Object t2 = Traverser.this.next();
                this.predicateSatisfied = t2 == null || predicate.test(t2);
                return this.predicateSatisfied ? t2 : null;
            }
        };
    }

    @Nonnull
    @CheckReturnValue
    default public Traverser<T> dropWhile(final @Nonnull Predicate<? super T> predicate) {
        return new Traverser<T>(){
            boolean predicateSatisfied = true;

            @Override
            public T next() {
                Object t2;
                if (!this.predicateSatisfied) {
                    return Traverser.this.next();
                }
                while ((t2 = Traverser.this.next()) != null) {
                    this.predicateSatisfied = predicate.test(t2);
                    if (this.predicateSatisfied) continue;
                    return t2;
                }
                return null;
            }
        };
    }

    @Nonnull
    @CheckReturnValue
    default public Traverser<T> append(final @Nonnull T item) {
        return new Traverser<T>(){
            T appendedItem;
            {
                this.appendedItem = item;
            }

            @Override
            public T next() {
                Object t2 = Traverser.this.next();
                if (t2 == null) {
                    try {
                        Object t3 = this.appendedItem;
                        return t3;
                    }
                    finally {
                        this.appendedItem = null;
                    }
                }
                return t2;
            }
        };
    }

    @Nonnull
    @CheckReturnValue
    default public Traverser<T> prepend(final @Nonnull T item) {
        return new Traverser<T>(){
            private boolean itemReturned;

            @Override
            public T next() {
                if (this.itemReturned) {
                    return Traverser.this.next();
                }
                this.itemReturned = true;
                return item;
            }
        };
    }

    @Nonnull
    @CheckReturnValue
    default public Traverser<T> peek(@Nonnull Consumer<? super T> action) {
        return () -> {
            T t2 = this.next();
            if (t2 != null) {
                action.accept((T)t2);
            }
            return t2;
        };
    }

    @Nonnull
    @CheckReturnValue
    default public Traverser<T> onFirstNull(final @Nonnull Runnable action) {
        return new Traverser<T>(){
            private boolean didRun;

            @Override
            public T next() {
                Object t2 = Traverser.this.next();
                if (t2 == null && !this.didRun) {
                    action.run();
                    this.didRun = true;
                }
                return t2;
            }
        };
    }
}

