/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet;

import com.hazelcast.jet.function.Observer;
import com.hazelcast.jet.impl.observer.BlockingIteratorObserver;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public interface Observable<T>
extends Iterable<T> {
    @Nonnull
    public String name();

    @Nonnull
    public UUID addObserver(@Nonnull Observer<T> var1);

    public void removeObserver(@Nonnull UUID var1);

    public Observable<T> configureCapacity(int var1);

    public int getConfiguredCapacity();

    @Override
    @Nonnull
    default public Iterator<T> iterator() {
        BlockingIteratorObserver observer = new BlockingIteratorObserver();
        this.addObserver(observer);
        return observer;
    }

    @Nonnull
    default public <R> CompletableFuture<R> toFuture(@Nonnull Function<Stream<T>, R> fn) {
        Objects.requireNonNull(fn, "fn");
        Iterator iterator2 = this.iterator();
        return CompletableFuture.supplyAsync(() -> {
            Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator2, 0);
            return fn.apply(StreamSupport.stream(spliterator, false));
        });
    }

    public void destroy();
}

