/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.executor;

import java.util.concurrent.ThreadFactory;

public abstract class AbstractExecutorThreadFactory
implements ThreadFactory {
    protected final ClassLoader classLoader;

    public AbstractExecutorThreadFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public final Thread newThread(Runnable r) {
        Thread t2 = this.createThread(r);
        t2.setContextClassLoader(this.classLoader);
        if (t2.getContextClassLoader() == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            t2.setContextClassLoader(cl);
        }
        if (t2.isDaemon()) {
            t2.setDaemon(false);
        }
        if (t2.getPriority() != 5) {
            t2.setPriority(5);
        }
        return t2;
    }

    protected abstract Thread createThread(Runnable var1);
}

