/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.logging;

import com.hazelcast.internal.tpcengine.logging.JulLoggerFactory;
import com.hazelcast.internal.tpcengine.logging.TpcLogger;
import com.hazelcast.internal.tpcengine.logging.TpcLoggerFactory;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;

public final class TpcLoggerLocator {
    private static final AtomicReference LOGGER = new AtomicReference();

    private TpcLoggerLocator() {
    }

    public static TpcLogger getLogger(Class clazz) {
        Object logger2 = LOGGER.get();
        if (logger2 != null) {
            if (logger2 instanceof TpcLoggerFactory) {
                return ((TpcLoggerFactory)logger2).getLogger(clazz);
            }
            Method method = (Method)logger2;
            try {
                return (TpcLogger)method.invoke(null, clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Class<?> loggerClazz = TpcLogger.class.getClassLoader().loadClass("com.hazelcast.logging.Logger");
            Method method = loggerClazz.getMethod("getLogger", Class.class);
            LOGGER.compareAndSet(null, method);
        }
        catch (Exception e) {
            JulLoggerFactory loggerFactor = new JulLoggerFactory();
            LOGGER.compareAndSet(null, loggerFactor);
        }
        return TpcLoggerLocator.getLogger(clazz);
    }
}

