/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.nio.PortableUtil;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableSerializer;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultPortableWriter
implements PortableWriter {
    private final PortableSerializer serializer;
    private final ClassDefinition cd;
    private final BufferObjectDataOutput out;
    private final int begin;
    private final int offset;
    private final Set<String> writtenFields;
    private boolean raw;

    DefaultPortableWriter(PortableSerializer serializer, BufferObjectDataOutput out, ClassDefinition cd2) throws IOException {
        this.serializer = serializer;
        this.out = out;
        this.cd = cd2;
        this.writtenFields = SetUtil.createHashSet(cd2.getFieldCount());
        this.begin = out.position();
        out.writeZeroBytes(4);
        out.writeInt(cd2.getFieldCount());
        this.offset = out.position();
        int fieldIndexesLength = (cd2.getFieldCount() + 1) * 4;
        out.writeZeroBytes(fieldIndexesLength);
    }

    public int getVersion() {
        return this.cd.getVersion();
    }

    @Override
    public void writeInt(@Nonnull String fieldName, int value) throws IOException {
        this.setPosition(fieldName, FieldType.INT);
        this.out.writeInt(value);
    }

    @Override
    public void writeLong(@Nonnull String fieldName, long value) throws IOException {
        this.setPosition(fieldName, FieldType.LONG);
        this.out.writeLong(value);
    }

    @Override
    public void writeUTF(@Nonnull String fieldName, String str) throws IOException {
        this.writeString(fieldName, str);
    }

    @Override
    public void writeString(@Nonnull String fieldName, @Nullable String value) throws IOException {
        this.setPosition(fieldName, FieldType.UTF);
        this.out.writeString(value);
    }

    @Override
    public void writeBoolean(@Nonnull String fieldName, boolean value) throws IOException {
        this.setPosition(fieldName, FieldType.BOOLEAN);
        this.out.writeBoolean(value);
    }

    @Override
    public void writeByte(@Nonnull String fieldName, byte value) throws IOException {
        this.setPosition(fieldName, FieldType.BYTE);
        this.out.writeByte(value);
    }

    @Override
    public void writeChar(@Nonnull String fieldName, int value) throws IOException {
        this.setPosition(fieldName, FieldType.CHAR);
        this.out.writeChar(value);
    }

    @Override
    public void writeDouble(@Nonnull String fieldName, double value) throws IOException {
        this.setPosition(fieldName, FieldType.DOUBLE);
        this.out.writeDouble(value);
    }

    @Override
    public void writeFloat(@Nonnull String fieldName, float value) throws IOException {
        this.setPosition(fieldName, FieldType.FLOAT);
        this.out.writeFloat(value);
    }

    @Override
    public void writeShort(@Nonnull String fieldName, short value) throws IOException {
        this.setPosition(fieldName, FieldType.SHORT);
        this.out.writeShort(value);
    }

    @Override
    public void writePortable(@Nonnull String fieldName, @Nullable Portable portable) throws IOException {
        FieldDefinition fd = this.setPosition(fieldName, FieldType.PORTABLE);
        boolean isNull = portable == null;
        this.out.writeBoolean(isNull);
        this.out.writeInt(fd.getFactoryId());
        this.out.writeInt(fd.getClassId());
        if (!isNull) {
            this.checkPortableAttributes(fd, portable);
            this.serializer.writeInternal(this.out, portable);
        }
    }

    public void writeGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord portable) throws IOException {
        FieldDefinition fd = this.setPosition(fieldName, FieldType.PORTABLE);
        boolean isNull = portable == null;
        this.out.writeBoolean(isNull);
        this.out.writeInt(fd.getFactoryId());
        this.out.writeInt(fd.getClassId());
        if (!isNull) {
            PortableGenericRecord record = (PortableGenericRecord)portable;
            this.checkPortableAttributes(fd, record.getClassDefinition());
            this.serializer.writePortableGenericRecordInternal(this.out, record);
        }
    }

    private void checkPortableAttributes(FieldDefinition fd, Portable portable) {
        if (fd.getFactoryId() != portable.getFactoryId()) {
            throw new HazelcastSerializationException("Wrong Portable type! Generic portable types are not supported!  Expected factory-id: " + fd.getFactoryId() + ", Actual factory-id: " + portable.getFactoryId());
        }
        if (fd.getClassId() != portable.getClassId()) {
            throw new HazelcastSerializationException("Wrong Portable type! Generic portable types are not supported! Expected class-id: " + fd.getClassId() + ", Actual class-id: " + portable.getClassId());
        }
    }

    private void checkPortableAttributes(FieldDefinition fd, ClassDefinition classDefinition) {
        if (fd.getFactoryId() != classDefinition.getFactoryId()) {
            throw new HazelcastSerializationException("Wrong Portable type! Generic portable types are not supported!  Expected factory-id: " + fd.getFactoryId() + ", Actual factory-id: " + classDefinition.getFactoryId());
        }
        if (fd.getClassId() != classDefinition.getClassId()) {
            throw new HazelcastSerializationException("Wrong Portable type! Generic portable types are not supported! Expected class-id: " + fd.getClassId() + ", Actual class-id: " + classDefinition.getClassId());
        }
    }

    @Override
    public void writeNullPortable(@Nonnull String fieldName, int factoryId, int classId) throws IOException {
        this.setPosition(fieldName, FieldType.PORTABLE);
        this.out.writeBoolean(true);
        this.out.writeInt(factoryId);
        this.out.writeInt(classId);
    }

    private <T> void writeNullable(@Nonnull String fieldName, FieldType fieldType, @Nullable T value, Writer<ObjectDataOutput, T> writer) throws IOException {
        this.setPosition(fieldName, fieldType);
        boolean isNull = value == null;
        this.out.writeBoolean(isNull);
        if (!isNull) {
            writer.write(this.out, value);
        }
    }

    @Override
    public void writeDecimal(@Nonnull String fieldName, @Nullable BigDecimal value) throws IOException {
        this.writeNullable(fieldName, FieldType.DECIMAL, value, IOUtil::writeBigDecimal);
    }

    @Override
    public void writeTime(@Nonnull String fieldName, @Nullable LocalTime value) throws IOException {
        this.writeNullable(fieldName, FieldType.TIME, value, PortableUtil::writeLocalTime);
    }

    @Override
    public void writeDate(@Nonnull String fieldName, @Nullable LocalDate value) throws IOException {
        this.writeNullable(fieldName, FieldType.DATE, value, PortableUtil::writeLocalDate);
    }

    @Override
    public void writeTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime value) throws IOException {
        this.writeNullable(fieldName, FieldType.TIMESTAMP, value, PortableUtil::writeLocalDateTime);
    }

    @Override
    public void writeTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime value) throws IOException {
        this.writeNullable(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE, value, PortableUtil::writeOffsetDateTime);
    }

    @Override
    public void writeByteArray(@Nonnull String fieldName, @Nullable byte[] values2) throws IOException {
        this.setPosition(fieldName, FieldType.BYTE_ARRAY);
        this.out.writeByteArray(values2);
    }

    @Override
    public void writeBooleanArray(@Nonnull String fieldName, @Nullable boolean[] booleans) throws IOException {
        this.setPosition(fieldName, FieldType.BOOLEAN_ARRAY);
        this.out.writeBooleanArray(booleans);
    }

    @Override
    public void writeCharArray(@Nonnull String fieldName, @Nullable char[] values2) throws IOException {
        this.setPosition(fieldName, FieldType.CHAR_ARRAY);
        this.out.writeCharArray(values2);
    }

    @Override
    public void writeIntArray(@Nonnull String fieldName, @Nullable int[] values2) throws IOException {
        this.setPosition(fieldName, FieldType.INT_ARRAY);
        this.out.writeIntArray(values2);
    }

    @Override
    public void writeLongArray(@Nonnull String fieldName, @Nullable long[] values2) throws IOException {
        this.setPosition(fieldName, FieldType.LONG_ARRAY);
        this.out.writeLongArray(values2);
    }

    @Override
    public void writeDoubleArray(@Nonnull String fieldName, @Nullable double[] values2) throws IOException {
        this.setPosition(fieldName, FieldType.DOUBLE_ARRAY);
        this.out.writeDoubleArray(values2);
    }

    @Override
    public void writeFloatArray(@Nonnull String fieldName, @Nullable float[] values2) throws IOException {
        this.setPosition(fieldName, FieldType.FLOAT_ARRAY);
        this.out.writeFloatArray(values2);
    }

    @Override
    public void writeShortArray(@Nonnull String fieldName, @Nullable short[] values2) throws IOException {
        this.setPosition(fieldName, FieldType.SHORT_ARRAY);
        this.out.writeShortArray(values2);
    }

    @Override
    public void writeUTFArray(@Nonnull String fieldName, @Nullable String[] values2) throws IOException {
        this.writeStringArray(fieldName, values2);
    }

    @Override
    public void writeStringArray(@Nonnull String fieldName, @Nullable String[] values2) throws IOException {
        this.setPosition(fieldName, FieldType.UTF_ARRAY);
        this.out.writeStringArray(values2);
    }

    @Override
    public void writePortableArray(@Nonnull String fieldName, @Nullable Portable[] portables) throws IOException {
        FieldDefinition fd = this.setPosition(fieldName, FieldType.PORTABLE_ARRAY);
        int len = portables == null ? -1 : portables.length;
        this.out.writeInt(len);
        this.out.writeInt(fd.getFactoryId());
        this.out.writeInt(fd.getClassId());
        if (len > 0) {
            int offset = this.out.position();
            this.out.writeZeroBytes(len * 4);
            for (int i = 0; i < len; ++i) {
                Portable portable = portables[i];
                this.checkPortableAttributes(fd, portable);
                int position = this.out.position();
                this.out.writeInt(offset + i * 4, position);
                this.serializer.writeInternal(this.out, portable);
            }
        }
    }

    private <T> void writeObjectArrayField(@Nonnull String fieldName, FieldType fieldType, @Nullable T[] values2, Writer<ObjectDataOutput, T> writer) throws IOException {
        this.setPosition(fieldName, fieldType);
        int len = values2 == null ? -1 : values2.length;
        this.out.writeInt(len);
        if (len > 0) {
            int offset = this.out.position();
            this.out.writeZeroBytes(len * 4);
            for (int i = 0; i < len; ++i) {
                int position = this.out.position();
                if (values2[i] == null) {
                    throw new HazelcastSerializationException("Array items can not be null");
                }
                this.out.writeInt(offset + i * 4, position);
                writer.write(this.out, values2[i]);
            }
        }
    }

    @Override
    public void writeDecimalArray(@Nonnull String fieldName, @Nullable BigDecimal[] values2) throws IOException {
        this.writeObjectArrayField(fieldName, FieldType.DECIMAL_ARRAY, values2, IOUtil::writeBigDecimal);
    }

    @Override
    public void writeTimeArray(@Nonnull String fieldName, @Nullable LocalTime[] values2) throws IOException {
        this.writeObjectArrayField(fieldName, FieldType.TIME_ARRAY, values2, PortableUtil::writeLocalTime);
    }

    @Override
    public void writeDateArray(@Nonnull String fieldName, @Nullable LocalDate[] values2) throws IOException {
        this.writeObjectArrayField(fieldName, FieldType.DATE_ARRAY, values2, PortableUtil::writeLocalDate);
    }

    @Override
    public void writeTimestampArray(@Nonnull String fieldName, @Nullable LocalDateTime[] values2) throws IOException {
        this.writeObjectArrayField(fieldName, FieldType.TIMESTAMP_ARRAY, values2, PortableUtil::writeLocalDateTime);
    }

    @Override
    public void writeTimestampWithTimezoneArray(@Nonnull String fieldName, @Nullable OffsetDateTime[] values2) throws IOException {
        this.writeObjectArrayField(fieldName, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY, values2, PortableUtil::writeOffsetDateTime);
    }

    void writeGenericRecordArray(@Nonnull String fieldName, @Nullable GenericRecord[] portables) throws IOException {
        FieldDefinition fd = this.setPosition(fieldName, FieldType.PORTABLE_ARRAY);
        int len = portables == null ? -1 : portables.length;
        this.out.writeInt(len);
        this.out.writeInt(fd.getFactoryId());
        this.out.writeInt(fd.getClassId());
        if (len > 0) {
            int offset = this.out.position();
            this.out.writeZeroBytes(len * 4);
            for (int i = 0; i < len; ++i) {
                PortableGenericRecord portable = (PortableGenericRecord)portables[i];
                this.checkPortableAttributes(fd, portable.getClassDefinition());
                int position = this.out.position();
                this.out.writeInt(offset + i * 4, position);
                this.serializer.writePortableGenericRecordInternal(this.out, portable);
            }
        }
    }

    private FieldDefinition setPosition(@Nonnull String fieldName, @Nonnull FieldType fieldType) throws IOException {
        if (this.raw) {
            throw new HazelcastSerializationException("Cannot write Portable fields after getRawDataOutput() is called!");
        }
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + "' for ClassDefinition {id: " + this.cd.getClassId() + ", version: " + this.cd.getVersion() + "}");
        }
        if (!this.writtenFields.add(fieldName)) {
            throw new HazelcastSerializationException("Field '" + fieldName + "' has already been written!");
        }
        int pos = this.out.position();
        int index = fd.getIndex();
        this.out.writeInt(this.offset + index * 4, pos);
        this.out.writeShort(fieldName.length());
        this.out.writeBytes(fieldName);
        this.out.writeByte(fieldType.getId());
        return fd;
    }

    @Override
    @Nonnull
    public ObjectDataOutput getRawDataOutput() throws IOException {
        if (!this.raw) {
            int pos = this.out.position();
            int index = this.cd.getFieldCount();
            this.out.writeInt(this.offset + index * 4, pos);
        }
        this.raw = true;
        return this.out;
    }

    void end() throws IOException {
        int position = this.out.position();
        this.out.writeInt(this.begin, position);
    }

    static interface Writer<O, T> {
        public void write(O var1, T var2) throws IOException;
    }
}

