/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.serialization.impl.FieldOperations;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.query.extractor.ValueCallback;
import com.hazelcast.query.extractor.ValueCollector;
import com.hazelcast.query.extractor.ValueReader;
import com.hazelcast.query.extractor.ValueReadingException;
import com.hazelcast.query.impl.getters.ExtractorHelper;
import com.hazelcast.query.impl.getters.MultiResult;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.function.Consumer;

public final class GenericRecordQueryReader
implements ValueReader {
    private final InternalGenericRecord rootRecord;
    private final boolean useLazyDeserialization;

    public GenericRecordQueryReader(InternalGenericRecord rootRecord) {
        this(rootRecord, false);
    }

    public GenericRecordQueryReader(InternalGenericRecord rootRecord, boolean useLazyDeserialization) {
        this.rootRecord = rootRecord;
        this.useLazyDeserialization = useLazyDeserialization;
    }

    public void read(String path, ValueCallback callback) {
        this.read(path, callback::onResult);
    }

    public void read(String path, ValueCollector collector) {
        this.read(path, collector::addObject);
    }

    private void read(String path, Consumer consumer) {
        try {
            Object result = this.read(path);
            if (result instanceof MultiResult) {
                MultiResult multiResult = (MultiResult)result;
                for (Object singleResult : multiResult.getResults()) {
                    consumer.accept(singleResult);
                }
            } else {
                consumer.accept(result);
            }
        }
        catch (IOException e) {
            throw new ValueReadingException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new ValueReadingException(e.getMessage(), e);
        }
    }

    public Object read(String fieldPath) throws IOException {
        InternalGenericRecord record;
        String fieldName;
        ListIterator<Object> iterator2;
        String path;
        if (fieldPath == null) {
            throw new IllegalArgumentException("field path can not be null");
        }
        if (fieldPath.endsWith(".")) {
            throw new IllegalArgumentException("Malformed path " + fieldPath);
        }
        if (this.rootRecord.hasField(fieldPath)) {
            return this.readLeaf(this.rootRecord, fieldPath);
        }
        LinkedList<InternalGenericRecord> results = new LinkedList<InternalGenericRecord>();
        results.add(this.rootRecord);
        MultiResult multiResult = new MultiResult(results);
        int begin = 0;
        int end = StringUtil.indexOf(fieldPath, '.');
        while (end != -1) {
            path = fieldPath.substring(begin, end);
            if (path.length() == 0) {
                throw new IllegalArgumentException("The token's length cannot be zero: " + fieldPath);
            }
            begin = end + 1;
            end = StringUtil.indexOf(fieldPath, '.', begin);
            iterator2 = results.listIterator();
            fieldName = ExtractorHelper.extractAttributeNameNameWithoutArguments(path);
            if (!path.contains("]")) {
                while (iterator2.hasNext()) {
                    InternalGenericRecord record2 = (InternalGenericRecord)iterator2.next();
                    if (!record2.hasField(fieldName)) {
                        iterator2.remove();
                        multiResult.setNullOrEmptyTarget(true);
                        continue;
                    }
                    InternalGenericRecord subGenericRecord = record2.getInternalGenericRecord(fieldName);
                    if (subGenericRecord == null) {
                        iterator2.remove();
                        multiResult.setNullOrEmptyTarget(true);
                        continue;
                    }
                    iterator2.set(subGenericRecord);
                }
                continue;
            }
            if (path.endsWith("[any]")) {
                while (iterator2.hasNext()) {
                    InternalGenericRecord record3 = (InternalGenericRecord)iterator2.next();
                    iterator2.remove();
                    if (!record3.hasField(fieldName)) {
                        multiResult.setNullOrEmptyTarget(true);
                        continue;
                    }
                    InternalGenericRecord[] genericRecords = record3.getArrayOfInternalGenericRecord(fieldName);
                    if (genericRecords == null || genericRecords.length == 0) {
                        multiResult.setNullOrEmptyTarget(true);
                        continue;
                    }
                    for (InternalGenericRecord internalGenericRecord : genericRecords) {
                        if (internalGenericRecord != null) {
                            iterator2.add(internalGenericRecord);
                            continue;
                        }
                        multiResult.setNullOrEmptyTarget(true);
                    }
                }
                continue;
            }
            int index = Integer.parseInt(ExtractorHelper.extractArgumentsFromAttributeName(path));
            while (iterator2.hasNext()) {
                record = (InternalGenericRecord)iterator2.next();
                if (!record.hasField(fieldName)) {
                    iterator2.remove();
                    multiResult.setNullOrEmptyTarget(true);
                    continue;
                }
                InternalGenericRecord genericRecord = record.getInternalGenericRecordFromArray(fieldName, index);
                if (genericRecord != null) {
                    iterator2.set(genericRecord);
                    continue;
                }
                iterator2.remove();
                multiResult.setNullOrEmptyTarget(true);
            }
        }
        path = fieldPath.substring(begin);
        if (path.length() == 0) {
            throw new IllegalArgumentException("The token's length cannot be zero: " + fieldPath);
        }
        iterator2 = results.listIterator();
        fieldName = ExtractorHelper.extractAttributeNameNameWithoutArguments(path);
        if (!path.contains("]")) {
            while (iterator2.hasNext()) {
                InternalGenericRecord record4 = (InternalGenericRecord)iterator2.next();
                Object leaf = this.readLeaf(record4, fieldName);
                iterator2.set(leaf);
            }
        } else if (path.endsWith("[any]")) {
            while (iterator2.hasNext()) {
                InternalGenericRecord record5 = (InternalGenericRecord)iterator2.next();
                iterator2.remove();
                Object leaves = this.readLeaf(record5, fieldName);
                if (leaves == null) {
                    multiResult.setNullOrEmptyTarget(true);
                    continue;
                }
                if (leaves instanceof Object[]) {
                    Object[] array = (Object[])leaves;
                    if (array.length == 0) {
                        multiResult.setNullOrEmptyTarget(true);
                        continue;
                    }
                    for (Object leaf : array) {
                        iterator2.add(leaf);
                    }
                    continue;
                }
                assert (leaves.getClass().isArray()) : "parameter is not an array";
                if (ExtractorHelper.reducePrimitiveArrayInto(iterator2::add, leaves)) continue;
                multiResult.setNullOrEmptyTarget(true);
            }
        } else {
            int index = Integer.parseInt(ExtractorHelper.extractArgumentsFromAttributeName(path));
            while (iterator2.hasNext()) {
                record = (InternalGenericRecord)iterator2.next();
                Object leaf = this.readIndexed(record, fieldName, index);
                iterator2.set(leaf);
            }
        }
        if (multiResult.isNullEmptyTarget()) {
            results.addFirst(null);
        } else if (results.size() == 1) {
            return results.get(0);
        }
        return multiResult;
    }

    private Object readIndexed(InternalGenericRecord record, String path, int index) {
        if (!record.hasField(path)) {
            return null;
        }
        FieldKind kind = record.getFieldKind(path);
        return FieldOperations.fieldOperations(kind).readIndexed(record, path, index);
    }

    private Object readLeaf(InternalGenericRecord record, String path) {
        if (!record.hasField(path)) {
            return null;
        }
        FieldKind kind = record.getFieldKind(path);
        if ((kind == FieldKind.COMPACT || kind == FieldKind.PORTABLE) && this.useLazyDeserialization) {
            return record.getInternalGenericRecord(path);
        }
        return FieldOperations.fieldOperations(kind).readAsLeafObjectOnQuery(record, path);
    }
}

