/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.partition.MigrationStateImpl;
import com.hazelcast.internal.partition.impl.MigrationTimer;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.partition.MigrationState;
import java.util.Date;
import java.util.concurrent.atomic.LongAdder;

public class MigrationStats {
    @Probe(name="lastRepartitionTime", unit=ProbeUnit.MS)
    private volatile long lastRepartitionTime;
    private volatile long lastRepartitionNanos;
    @Probe(name="plannedMigrations")
    private volatile int plannedMigrations;
    @Probe(name="completedMigrations")
    private final LongAdder completedMigrations = new LongAdder();
    @Probe(name="totalCompletedMigrations")
    private final LongAdder totalCompletedMigrations = new LongAdder();
    private final MigrationTimer migrationOperationTime = new MigrationTimer();
    private final MigrationTimer destinationCommitTime = new MigrationTimer();
    private final MigrationTimer migrationTime = new MigrationTimer();

    void markNewRepartition(int migrations) {
        this.lastRepartitionTime = Clock.currentTimeMillis();
        this.lastRepartitionNanos = Timer.nanos();
        this.plannedMigrations = migrations;
        this.migrationOperationTime.markNewRepartition();
        this.destinationCommitTime.markNewRepartition();
        this.migrationTime.markNewRepartition();
        this.completedMigrations.reset();
    }

    void incrementCompletedMigrations() {
        this.completedMigrations.increment();
        this.totalCompletedMigrations.increment();
    }

    public Date getLastRepartitionTime() {
        return new Date(this.lastRepartitionTime);
    }

    public int getPlannedMigrations() {
        return this.plannedMigrations;
    }

    public int getCompletedMigrations() {
        return this.completedMigrations.intValue();
    }

    public int getRemainingMigrations() {
        return this.plannedMigrations - this.getCompletedMigrations();
    }

    public int getTotalCompletedMigrations() {
        return this.totalCompletedMigrations.intValue();
    }

    void recordMigrationOperationTime() {
        this.migrationOperationTime.calculateElapsed(this.lastRepartitionNanos);
    }

    public long getElapsedMigrationOperationTime() {
        return this.migrationOperationTime.getElapsedMilliseconds();
    }

    @Probe(name="elapsedMigrationOperationTime", unit=ProbeUnit.NS)
    public long getElapsedMigrationOperationTimeNanoseconds() {
        return this.migrationOperationTime.getElapsedNanoseconds();
    }

    public long getTotalElapsedMigrationOperationTime() {
        return this.migrationOperationTime.getTotalElapsedMilliseconds();
    }

    @Probe(name="totalElapsedMigrationOperationTime", unit=ProbeUnit.NS)
    public long getTotalElapsedMigrationOperationTimeNanoseconds() {
        return this.migrationOperationTime.getTotalElapsedNanoseconds();
    }

    void recordDestinationCommitTime() {
        this.destinationCommitTime.calculateElapsed(this.lastRepartitionNanos);
    }

    public long getElapsedDestinationCommitTime() {
        return this.destinationCommitTime.getElapsedMilliseconds();
    }

    @Probe(name="elapsedDestinationCommitTime", unit=ProbeUnit.NS)
    public long getElapsedDestinationCommitTimeNanoseconds() {
        return this.destinationCommitTime.getElapsedNanoseconds();
    }

    public long getTotalElapsedDestinationCommitTime() {
        return this.destinationCommitTime.getTotalElapsedMilliseconds();
    }

    @Probe(name="totalElapsedDestinationCommitTime", unit=ProbeUnit.NS)
    public long getTotalElapsedDestinationCommitTimeNanoseconds() {
        return this.destinationCommitTime.getTotalElapsedNanoseconds();
    }

    void recordMigrationTaskTime() {
        this.migrationTime.calculateElapsed(this.lastRepartitionNanos);
    }

    public long getElapsedMigrationTime() {
        return this.migrationTime.getElapsedMilliseconds();
    }

    @Probe(name="elapsedMigrationTime", unit=ProbeUnit.NS)
    public long getElapsedMigrationTimeNanoseconds() {
        return this.migrationTime.getElapsedNanoseconds();
    }

    public long getTotalElapsedMigrationTime() {
        return this.migrationTime.getTotalElapsedMilliseconds();
    }

    @Probe(name="totalElapsedMigrationTime", unit=ProbeUnit.NS)
    public long getTotalElapsedMigrationTimeNanoseconds() {
        return this.migrationTime.getTotalElapsedNanoseconds();
    }

    public MigrationState toMigrationState() {
        return new MigrationStateImpl(this.lastRepartitionTime, this.plannedMigrations, this.completedMigrations.intValue(), this.getElapsedMigrationTime());
    }

    public String formatToString(boolean detailed) {
        StringBuilder s2 = new StringBuilder();
        s2.append("repartitionTime=").append(this.getLastRepartitionTime()).append(", plannedMigrations=").append(this.plannedMigrations).append(", completedMigrations=").append(this.getCompletedMigrations()).append(", remainingMigrations=").append(this.getRemainingMigrations()).append(", totalCompletedMigrations=").append(this.getTotalCompletedMigrations());
        if (detailed) {
            s2.append(", elapsedMigrationOperationTime=").append(this.getElapsedMigrationOperationTime()).append("ms").append(", totalElapsedMigrationOperationTime=").append(this.getTotalElapsedMigrationOperationTime()).append("ms").append(", elapsedDestinationCommitTime=").append(this.getElapsedDestinationCommitTime()).append("ms").append(", totalElapsedDestinationCommitTime=").append(this.getTotalElapsedDestinationCommitTime()).append("ms").append(", elapsedMigrationTime=").append(this.getElapsedMigrationTime()).append("ms").append(", totalElapsedMigrationTime=").append(this.getTotalElapsedMigrationTime()).append("ms");
        }
        return s2.toString();
    }

    public String toString() {
        return "MigrationStats{" + this.formatToString(true) + "}";
    }
}

