/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl.executejar;

import com.hazelcast.instance.impl.BootstrappedInstanceProxy;
import com.hazelcast.instance.impl.executejar.ExecuteJarHelper;
import com.hazelcast.instance.impl.executejar.ExecuteJobParameters;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MemberExecuteJar {
    private static final ILogger LOGGER = Logger.getLogger(MemberExecuteJar.class);

    public void executeJar(@Nonnull BootstrappedInstanceProxy instanceProxy, ExecuteJobParameters executeJobParameters, @Nullable String mainClassName, @Nonnull List<String> args2) throws IOException, InvocationTargetException, IllegalAccessException, ClassNotFoundException {
        String jarPath = executeJobParameters.getJarPath();
        mainClassName = ExecuteJarHelper.findMainClassNameForJar(jarPath, mainClassName);
        URL jarUrl = new File(jarPath).toURI().toURL();
        try (URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{jarUrl}, MemberExecuteJar.class.getClassLoader());){
            Method mainMethod = ExecuteJarHelper.findMainMethodForJar(classLoader, mainClassName);
            LOGGER.info("Found mainClassName :" + mainClassName + " and main method");
            this.invokeMain(instanceProxy, executeJobParameters, mainMethod, args2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeMain(BootstrappedInstanceProxy instanceProxy, ExecuteJobParameters executeJobParameters, Method mainMethod, List<String> args2) throws IllegalAccessException, InvocationTargetException {
        try {
            instanceProxy.setExecuteJobParameters(executeJobParameters);
            String[] jobArgs = args2.toArray(new String[0]);
            mainMethod.invoke(null, new Object[]{jobArgs});
        }
        finally {
            instanceProxy.removeExecuteJobParameters();
        }
    }
}

