/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.logging.ILogger;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;

final class DuplicatedResourcesScanner {
    private DuplicatedResourcesScanner() {
    }

    static void checkForDuplicates(ClassLoader classLoader, ILogger logger2, String resourceName) {
        try {
            ArrayList<URL> resources = Collections.list(classLoader.getResources(resourceName));
            if (resources.size() > 1) {
                String formattedResourceUrls = resources.stream().map(URL::toString).collect(Collectors.joining(", "));
                logger2.warning("WARNING: Classpath misconfiguration: found multiple " + resourceName + " resources: " + formattedResourceUrls);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

