/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.proxy.ClientMapProxy;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ReadOnly;
import com.hazelcast.internal.adapter.IMapDataStructureAdapter;
import com.hazelcast.internal.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.CollectionUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.LocalMapStats;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class NearCachedClientMapProxy<K, V>
extends ClientMapProxy<K, V> {
    private boolean serializeKeys;
    private NearCache<Object, Object> nearCache;
    private volatile UUID invalidationListenerId;

    public NearCachedClientMapProxy(String serviceName, String name, ClientContext context) {
        super(serviceName, name, context);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.name);
        this.serializeKeys = nearCacheConfig.isSerializeKeys();
        NearCacheManager nearCacheManager = this.getContext().getNearCacheManager(this.getServiceName());
        this.nearCache = nearCacheManager.getOrCreateNearCache(this.name, nearCacheConfig);
        if (nearCacheConfig.isInvalidateOnChange()) {
            this.registerInvalidationListener();
        }
        if (nearCacheConfig.getPreloaderConfig().isEnabled()) {
            nearCacheManager.startPreloading(this.nearCache, new IMapDataStructureAdapter(this));
        }
    }

    @Override
    protected boolean containsKeyInternal(Object key) {
        Object cached = this.getCachedValue(key = this.toNearCacheKey(key), false);
        if (cached != NearCache.NOT_CACHED) {
            return cached != null;
        }
        return super.containsKeyInternal(key);
    }

    @Override
    protected V getInternal(Object key) {
        Object value = this.getCachedValue(key = this.toNearCacheKey(key), true);
        if (value != NearCache.NOT_CACHED) {
            return (V)value;
        }
        try {
            Data keyData = this.toData(key);
            long reservationId = this.nearCache.tryReserveForUpdate(key, keyData, NearCache.UpdateSemantic.READ_UPDATE);
            value = super.getInternal(keyData);
            if (reservationId != -1L) {
                value = this.tryPublishReserved(key, value, reservationId);
            }
            return (V)value;
        }
        catch (Throwable throwable) {
            this.invalidateNearCache(key);
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean setTtlInternal(Object key, long ttl, TimeUnit timeUnit) {
        key = this.toNearCacheKey(key);
        try {
            boolean bl = super.setTtlInternal(key, ttl, timeUnit);
            return bl;
        }
        finally {
            this.invalidateNearCache(key);
        }
    }

    @Override
    public InternalCompletableFuture<V> getAsync(@Nonnull K key) {
        ClientInvocationFuture invocationFuture;
        Preconditions.checkNotNull(key, "Null key is not allowed!");
        Object ncKey = this.toNearCacheKey(key);
        Object value = this.getCachedValue(ncKey, false);
        if (value != NearCache.NOT_CACHED) {
            return InternalCompletableFuture.newCompletedFuture(value, this.getSerializationService());
        }
        Data keyData = this.toData(ncKey);
        long reservationId = this.nearCache.tryReserveForUpdate(ncKey, keyData, NearCache.UpdateSemantic.READ_UPDATE);
        try {
            invocationFuture = super.getAsyncInternal(keyData);
        }
        catch (Throwable t3) {
            this.invalidateNearCache(ncKey);
            throw ExceptionUtil.rethrow(t3);
        }
        if (reservationId != -1L) {
            invocationFuture.whenCompleteAsync((response, t2) -> {
                if (t2 == null) {
                    Data newDecodedResponse = MapGetCodec.decodeResponse(response);
                    this.nearCache.tryPublishReserved(ncKey, newDecodedResponse, reservationId, false);
                } else {
                    this.invalidateNearCache(ncKey);
                }
            }, (Executor)this.getClient().getTaskScheduler());
        }
        return new ClientDelegatingFuture(this.getAsyncInternal(key), this.getSerializationService(), MapGetCodec::decodeResponse);
    }

    @Override
    protected Data removeInternal(Object key) {
        key = this.toNearCacheKey(key);
        try {
            Data data = super.removeInternal(key);
            return data;
        }
        finally {
            this.invalidateNearCache(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeInternal(Object key, Object value) {
        boolean removed;
        key = this.toNearCacheKey(key);
        try {
            removed = super.removeInternal(key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return removed;
    }

    @Override
    protected void removeAllInternal(Predicate predicate) {
        try {
            super.removeAllInternal(predicate);
        }
        finally {
            this.nearCache.clear();
        }
    }

    @Override
    protected void deleteInternal(Object key) {
        key = this.toNearCacheKey(key);
        try {
            super.deleteInternal(key);
        }
        finally {
            this.invalidateNearCache(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InternalCompletableFuture<V> putAsyncInternal(long ttl, TimeUnit timeunit, Long maxIdle, TimeUnit maxIdleUnit, Object key, Object value) {
        InternalCompletableFuture future;
        key = this.toNearCacheKey(key);
        try {
            future = super.putAsyncInternal(ttl, timeunit, maxIdle, maxIdleUnit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InternalCompletableFuture<Void> setAsyncInternal(long ttl, TimeUnit timeunit, Long maxIdle, TimeUnit maxIdleUnit, Object key, Object value) {
        InternalCompletableFuture<Void> future;
        key = this.toNearCacheKey(key);
        try {
            future = super.setAsyncInternal(ttl, timeunit, maxIdle, maxIdleUnit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return future;
    }

    @Override
    protected InternalCompletableFuture<V> removeAsyncInternal(Object key) {
        InternalCompletableFuture future;
        key = this.toNearCacheKey(key);
        try {
            future = super.removeAsyncInternal(key);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean tryRemoveInternal(long timeout2, TimeUnit timeunit, Object key) {
        boolean removed;
        key = this.toNearCacheKey(key);
        try {
            removed = super.tryRemoveInternal(timeout2, timeunit, key);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean tryPutInternal(long timeout2, TimeUnit timeunit, Object key, Object value) {
        boolean putInternal;
        key = this.toNearCacheKey(key);
        try {
            putInternal = super.tryPutInternal(timeout2, timeunit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return putInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V putInternal(long ttl, TimeUnit ttlUnit, Long maxIdle, TimeUnit maxIdleUnit, Object key, Object value) {
        Object previousValue;
        key = this.toNearCacheKey(key);
        try {
            previousValue = super.putInternal(ttl, ttlUnit, maxIdle, maxIdleUnit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return previousValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putTransientInternal(long ttl, TimeUnit timeunit, Long maxIdle, TimeUnit maxIdleUnit, Object key, Object value) {
        key = this.toNearCacheKey(key);
        try {
            super.putTransientInternal(ttl, timeunit, maxIdle, maxIdleUnit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V putIfAbsentInternal(long ttl, TimeUnit timeunit, Long maxIdle, TimeUnit maxIdleUnit, Object key, Object value) {
        Object previousValue;
        key = this.toNearCacheKey(key);
        try {
            previousValue = super.putIfAbsentInternal(ttl, timeunit, maxIdle, maxIdleUnit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return previousValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean replaceIfSameInternal(Object key, Object oldValue, Object newValue) {
        boolean replaceIfSame;
        key = this.toNearCacheKey(key);
        try {
            replaceIfSame = super.replaceIfSameInternal(key, oldValue, newValue);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return replaceIfSame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V replaceInternal(Object key, Object value) {
        Object v;
        key = this.toNearCacheKey(key);
        try {
            v = super.replaceInternal(key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setInternal(long ttl, TimeUnit timeunit, Long maxIdle, TimeUnit maxIdleUnit, Object key, Object value) {
        key = this.toNearCacheKey(key);
        try {
            super.setInternal(ttl, timeunit, maxIdle, maxIdleUnit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
    }

    @Override
    protected boolean evictInternal(Object key) {
        boolean evicted;
        key = this.toNearCacheKey(key);
        try {
            evicted = super.evictInternal(key);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return evicted;
    }

    @Override
    public void evictAll() {
        try {
            super.evictAll();
        }
        finally {
            this.nearCache.clear();
        }
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        super.loadAll(replaceExistingValues);
        if (replaceExistingValues) {
            this.nearCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadAllInternal(boolean replaceExistingValues, Collection<?> keysParameter) {
        Collection<?> keys2 = this.serializeKeys ? CollectionUtil.objectToDataCollection(keysParameter, this.getSerializationService()) : keysParameter;
        try {
            super.loadAllInternal(replaceExistingValues, keys2);
        }
        finally {
            for (Object key : keys2) {
                this.invalidateNearCache(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getAllInternal(Set<K> keys2, Map<Integer, List<Data>> partitionToKeyData, List<Object> resultingKeyValuePairs) {
        Map<Object, Data> keyMap = MapUtil.createHashMap(keys2.size());
        if (this.serializeKeys) {
            this.fillPartitionToKeyData(keys2, partitionToKeyData, keyMap, null);
        }
        LinkedList<K> ncKeys = this.serializeKeys ? keyMap.values() : new LinkedList<K>(keys2);
        this.populateResultFromNearCache(ncKeys, resultingKeyValuePairs);
        if (ncKeys.isEmpty()) {
            return;
        }
        Map<Data, Object> reverseKeyMap = null;
        if (!this.serializeKeys) {
            reverseKeyMap = MapUtil.createHashMap(ncKeys.size());
            this.fillPartitionToKeyData(keys2, partitionToKeyData, keyMap, reverseKeyMap);
        }
        Map<Object, Long> reservations = this.getNearCacheReservations(ncKeys, keyMap);
        try {
            int currentSize = resultingKeyValuePairs.size();
            super.getAllInternal(keys2, partitionToKeyData, resultingKeyValuePairs);
            this.populateResultFromRemote(currentSize, resultingKeyValuePairs, reservations, reverseKeyMap);
        }
        finally {
            this.releaseRemainingReservedKeys(reservations);
        }
    }

    private void populateResultFromNearCache(Collection<?> keys2, List<Object> resultingKeyValuePairs) {
        Iterator<?> iterator2 = keys2.iterator();
        while (iterator2.hasNext()) {
            Object key = iterator2.next();
            Object cached = this.getCachedValue(key, true);
            if (cached == null || cached == NearCache.NOT_CACHED) continue;
            resultingKeyValuePairs.add(key);
            resultingKeyValuePairs.add(cached);
            iterator2.remove();
        }
    }

    private Map<Object, Long> getNearCacheReservations(Collection<?> nearCacheKeys, Map<Object, Data> keyMap) {
        Map<Object, Long> reservations = MapUtil.createHashMap(nearCacheKeys.size());
        for (Object key : nearCacheKeys) {
            Data keyData;
            long reservationId = this.nearCache.tryReserveForUpdate(key, keyData = this.serializeKeys ? (Data)key : keyMap.get(key), NearCache.UpdateSemantic.READ_UPDATE);
            if (reservationId == -1L) continue;
            reservations.put(key, reservationId);
        }
        return reservations;
    }

    private void populateResultFromRemote(int currentSize, List<Object> resultingKeyValuePairs, Map<Object, Long> reservations, Map<Data, Object> reverseKeyMap) {
        for (int i = currentSize; i < resultingKeyValuePairs.size(); i += 2) {
            Long reservationId;
            Data ncKey;
            Data keyData = (Data)resultingKeyValuePairs.get(i);
            Data valueData = (Data)resultingKeyValuePairs.get(i + 1);
            Data data = ncKey = this.serializeKeys ? keyData : reverseKeyMap.get(keyData);
            if (!this.serializeKeys) {
                resultingKeyValuePairs.set(i, ncKey);
            }
            if ((reservationId = reservations.get(ncKey)) == null) continue;
            Object cachedValue = this.tryPublishReserved(ncKey, valueData, reservationId);
            resultingKeyValuePairs.set(i + 1, cachedValue);
            reservations.remove(ncKey);
        }
    }

    private void releaseRemainingReservedKeys(Map<Object, Long> reservedKeys) {
        for (Map.Entry<Object, Long> entry : reservedKeys.entrySet()) {
            Object key = this.serializeKeys ? this.toData(entry.getKey()) : entry.getKey();
            this.invalidateNearCache(key);
        }
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        LocalMapStatsImpl localMapStats = (LocalMapStatsImpl)super.getLocalMapStats();
        localMapStats.setNearCacheStats(this.nearCache.getNearCacheStats());
        return localMapStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected <R> InternalCompletableFuture<Map<K, R>> submitToKeysInternal(@Nonnull Set<K> objectKeys, @Nonnull Collection<Data> dataKeys, @Nonnull EntryProcessor<K, V, R> entryProcessor) {
        Collection<Data> nearCacheKeys;
        InternalCompletableFuture<Map<K, R>> internalCompletableFuture;
        try {
            internalCompletableFuture = super.submitToKeysInternal(objectKeys, dataKeys, entryProcessor);
            Collection<Data> collection = nearCacheKeys = this.serializeKeys ? dataKeys : objectKeys;
        }
        catch (Throwable throwable) {
            Collection<Data> nearCacheKeys2;
            Collection<Data> collection = nearCacheKeys2 = this.serializeKeys ? dataKeys : objectKeys;
            if (!(entryProcessor instanceof ReadOnly)) {
                nearCacheKeys2.forEach(this::invalidateNearCache);
            }
            throw throwable;
        }
        if (!(entryProcessor instanceof ReadOnly)) {
            nearCacheKeys.forEach(this::invalidateNearCache);
        }
        return internalCompletableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R executeOnKeyInternal(Object key, EntryProcessor<K, V, R> entryProcessor) {
        R response;
        key = this.toNearCacheKey(key);
        try {
            response = super.executeOnKeyInternal(key, entryProcessor);
        }
        finally {
            if (!(entryProcessor instanceof ReadOnly)) {
                this.invalidateNearCache(key);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> InternalCompletableFuture<R> submitToKeyInternal(Object key, EntryProcessor<K, V, R> entryProcessor) {
        InternalCompletableFuture<R> future;
        key = this.toNearCacheKey(key);
        try {
            future = super.submitToKeyInternal(key, entryProcessor);
        }
        finally {
            if (!(entryProcessor instanceof ReadOnly)) {
                this.invalidateNearCache(key);
            }
        }
        return future;
    }

    @Override
    protected <R> Map<K, R> prepareResult(Collection<Map.Entry<Data, Data>> entrySet, boolean shouldInvalidate) {
        if (CollectionUtil.isEmpty(entrySet)) {
            return Collections.emptyMap();
        }
        Map result = MapUtil.createHashMap(entrySet.size());
        for (Map.Entry<Data, Data> entry : entrySet) {
            Data dataKey = entry.getKey();
            Object key = this.toObject(dataKey);
            Object value = this.toObject(entry.getValue());
            if (shouldInvalidate) {
                this.invalidateNearCache(this.serializeKeys ? dataKey : key);
            }
            result.put(key, value);
        }
        return result;
    }

    @Override
    protected void finalizePutAll(Map<? extends K, ? extends V> map, Map<Integer, List<Map.Entry<Data, Data>>> entryMap) {
        if (this.serializeKeys) {
            for (List<Map.Entry<Data, Data>> entries : entryMap.values()) {
                for (Map.Entry<Data, Data> entry : entries) {
                    this.invalidateNearCache(entry.getKey());
                }
            }
        } else {
            for (K key : map.keySet()) {
                this.invalidateNearCache(key);
            }
        }
    }

    @Override
    protected void finalizePutAll(Collection<? extends EntryView<K, V>> entries, Map<Integer, List<SimpleEntryView<Data, Data>>> entriesByPartition) {
        if (this.serializeKeys) {
            for (List<SimpleEntryView<Data, Data>> partitionEntries : entriesByPartition.values()) {
                for (EntryView entryView : partitionEntries) {
                    this.invalidateNearCache(entryView.getKey());
                }
            }
        } else {
            for (EntryView<K, V> entry : entries) {
                this.invalidateNearCache(entry.getKey());
            }
        }
    }

    @Override
    public void clear() {
        this.nearCache.clear();
        super.clear();
    }

    @Override
    protected void postDestroy() {
        try {
            this.destroyNearCache();
        }
        finally {
            super.postDestroy();
        }
    }

    @Override
    protected void onShutdown() {
        try {
            this.destroyNearCache();
        }
        finally {
            super.onShutdown();
        }
    }

    private void destroyNearCache() {
        this.removeNearCacheInvalidationListener();
        this.getContext().getNearCacheManager(this.getServiceName()).destroyNearCache(this.name);
    }

    private Object toNearCacheKey(Object key) {
        return this.serializeKeys ? this.toData(key) : key;
    }

    private Object tryPublishReserved(Object key, Object value, long reservationId) {
        assert (value != NearCache.NOT_CACHED);
        Object cachedValue = this.nearCache.tryPublishReserved(key, value, reservationId, true);
        return cachedValue != null ? cachedValue : value;
    }

    private Object getCachedValue(Object key, boolean deserializeValue) {
        Object value = this.nearCache.get(key);
        if (value == null) {
            return NearCache.NOT_CACHED;
        }
        if (value == NearCache.CACHED_AS_NULL) {
            return null;
        }
        return deserializeValue ? this.toObject(value) : value;
    }

    public NearCache<Object, Object> getNearCache() {
        return this.nearCache;
    }

    private void invalidateNearCache(Object key) {
        this.nearCache.invalidate(key);
    }

    private void registerInvalidationListener() {
        try {
            this.invalidationListenerId = this.addNearCacheInvalidationListener(new NearCacheInvalidationEventHandler());
        }
        catch (Exception e) {
            ILogger logger2 = this.getContext().getLoggingService().getLogger(this.getClass());
            logger2.severe("-----------------\nNear Cache is not initialized!\n-----------------", e);
        }
    }

    public UUID addNearCacheInvalidationListener(EventHandler handler) {
        return this.registerListener(this.createNearCacheInvalidationListenerCodec(), handler);
    }

    private ListenerMessageCodec createNearCacheInvalidationListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddNearCacheInvalidationListenerCodec.encodeRequest(NearCachedClientMapProxy.this.name, EntryEventType.INVALIDATION.getType(), localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return MapAddNearCacheInvalidationListenerCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(NearCachedClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    private void removeNearCacheInvalidationListener() {
        UUID invalidationListenerId = this.invalidationListenerId;
        if (invalidationListenerId == null) {
            return;
        }
        this.getContext().getRepairingTask(this.getServiceName()).deregisterHandler(this.name);
        this.deregisterListener(invalidationListenerId);
    }

    private final class NearCacheInvalidationEventHandler
    extends MapAddNearCacheInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private volatile RepairingHandler repairingHandler;

        private NearCacheInvalidationEventHandler() {
        }

        @Override
        public void beforeListenerRegister(Connection connection) {
            RepairingTask repairingTask = NearCachedClientMapProxy.this.getContext().getRepairingTask(NearCachedClientMapProxy.this.getServiceName());
            this.repairingHandler = repairingTask.registerAndGetHandler(NearCachedClientMapProxy.this.name, NearCachedClientMapProxy.this.nearCache);
        }

        @Override
        public void handleIMapInvalidationEvent(Data key, UUID sourceUuid, UUID partitionUuid, long sequence) {
            this.repairingHandler.handle(key, sourceUuid, partitionUuid, sequence);
        }

        @Override
        public void handleIMapBatchInvalidationEvent(Collection<Data> keys2, Collection<UUID> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            this.repairingHandler.handle(keys2, sourceUuids, partitionUuids, sequences);
        }
    }
}

