/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddMigrationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ClientAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ClientRemoveMigrationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ClientRemovePartitionLostListenerCodec;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.ClientListenerService;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.partition.PartitionLostEventImpl;
import com.hazelcast.internal.partition.ReplicaMigrationEventImpl;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.MigrationState;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.partition.PartitionService;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PartitionServiceProxy
implements PartitionService {
    private final ClientPartitionService partitionService;
    private final ClientListenerService listenerService;
    private final ClientClusterService clusterService;

    public PartitionServiceProxy(ClientPartitionService partitionService, ClientListenerService listenerService, ClientClusterService clusterService) {
        this.partitionService = partitionService;
        this.listenerService = listenerService;
        this.clusterService = clusterService;
    }

    @Override
    public Set<Partition> getPartitions() {
        int partitionCount = this.partitionService.getPartitionCount();
        LinkedHashSet<Partition> partitions = new LinkedHashSet<Partition>(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            Partition partition = this.partitionService.getPartition(i);
            partitions.add(partition);
        }
        return partitions;
    }

    @Override
    public Partition getPartition(@Nonnull Object key) {
        Preconditions.checkNotNull(key, "key cannot be null");
        int partitionId = this.partitionService.getPartitionId(key);
        return this.partitionService.getPartition(partitionId);
    }

    @Override
    public UUID addMigrationListener(@Nonnull MigrationListener migrationListener) {
        Preconditions.checkNotNull(migrationListener, "migrationListener can't be null");
        ClientMigrationEventHandler handler = new ClientMigrationEventHandler(migrationListener);
        return this.listenerService.registerListener(this.createMigrationListenerCodec(), handler);
    }

    @Override
    public boolean removeMigrationListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId can't be null");
        return this.listenerService.deregisterListener(registrationId);
    }

    @Override
    public UUID addPartitionLostListener(@Nonnull PartitionLostListener partitionLostListener) {
        Preconditions.checkNotNull(partitionLostListener, "migrationListener can't be null");
        ClientPartitionLostEventHandler handler = new ClientPartitionLostEventHandler(partitionLostListener);
        return this.listenerService.registerListener(this.createPartitionLostListenerCodec(), handler);
    }

    @Override
    public boolean removePartitionLostListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId can't be null");
        return this.listenerService.deregisterListener(registrationId);
    }

    @Override
    public boolean isClusterSafe() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMemberSafe(Member member) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocalMemberSafe() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean forceLocalMemberToBeSafe(long timeout2, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    private ListenerMessageCodec createPartitionLostListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ClientAddPartitionLostListenerCodec.encodeRequest(localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return ClientAddPartitionLostListenerCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return ClientRemovePartitionLostListenerCodec.encodeRequest(realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ClientRemovePartitionLostListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    private ListenerMessageCodec createMigrationListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ClientAddMigrationListenerCodec.encodeRequest(localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return ClientAddMigrationListenerCodec.decodeResponse(clientMessage);
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return ClientRemoveMigrationListenerCodec.encodeRequest(realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ClientRemoveMigrationListenerCodec.decodeResponse(clientMessage);
            }
        };
    }

    private class ClientMigrationEventHandler
    extends ClientAddMigrationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final MigrationListener listener;

        ClientMigrationEventHandler(MigrationListener listener) {
            this.listener = listener;
        }

        @Override
        public void handleMigrationEvent(MigrationState migrationState, int type) {
            MigrationProcessState migrationProcessState = MigrationProcessState.fromId(type);
            if (migrationProcessState == null) {
                return;
            }
            switch (migrationProcessState) {
                case STARTED: {
                    this.listener.migrationStarted(migrationState);
                    break;
                }
                case FINISHED: {
                    this.listener.migrationFinished(migrationState);
                    break;
                }
            }
        }

        @Override
        public void handleReplicaMigrationEvent(MigrationState migrationState, int partitionId, int replicaIndex, @Nullable UUID sourceUuid, @Nullable UUID destUuid, boolean success, long elapsedTime) {
            Member destination;
            Member source2 = this.findMember(sourceUuid);
            ReplicaMigrationEventImpl event = new ReplicaMigrationEventImpl(migrationState, partitionId, replicaIndex, source2, destination = this.findMember(destUuid), success, elapsedTime);
            if (event.isSuccess()) {
                this.listener.replicaMigrationCompleted(event);
            } else {
                this.listener.replicaMigrationFailed(event);
            }
        }

        private Member findMember(@Nullable UUID memberUuid) {
            return memberUuid != null ? PartitionServiceProxy.this.clusterService.getMember(memberUuid) : null;
        }
    }

    private class ClientPartitionLostEventHandler
    extends ClientAddPartitionLostListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final PartitionLostListener listener;

        ClientPartitionLostEventHandler(PartitionLostListener listener) {
            this.listener = listener;
        }

        @Override
        public void handlePartitionLostEvent(int partitionId, int lostBackupCount, UUID source2) {
            Member member = PartitionServiceProxy.this.clusterService.getMember(source2);
            this.listener.partitionLost(new PartitionLostEventImpl(partitionId, lostBackupCount, member.getAddress()));
        }
    }

    public static enum MigrationProcessState {
        STARTED(0),
        FINISHED(1);

        private final int id;

        private MigrationProcessState(int id) {
            this.id = id;
        }

        @Nullable
        public static MigrationProcessState fromId(int id) {
            switch (id) {
                case 0: {
                    return STARTED;
                }
                case 1: {
                    return FINISHED;
                }
            }
            return null;
        }

        public int getId() {
            return this.id;
        }
    }
}

