/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.scheduledexecutor;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetAllScheduledFuturesCodec;
import com.hazelcast.client.impl.protocol.task.AbstractMessageTask;
import com.hazelcast.client.impl.protocol.task.BlockingMessageTask;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.impl.InvokeOnMembers;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskHandlerAccessor;
import com.hazelcast.scheduledexecutor.impl.operations.GetAllScheduledOnMemberOperation;
import com.hazelcast.scheduledexecutor.impl.operations.GetAllScheduledOnPartitionOperationFactory;
import com.hazelcast.security.permission.ScheduledExecutorPermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class ScheduledExecutorGetAllScheduledMessageTask
extends AbstractMessageTask<String>
implements BlockingMessageTask {
    public ScheduledExecutorGetAllScheduledMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void processMessage() {
        LinkedList<ScheduledTaskHandler> scheduledTasks = new LinkedList<ScheduledTaskHandler>();
        this.retrieveAllMemberOwnedScheduled(scheduledTasks);
        this.retrieveAllPartitionOwnedScheduled(scheduledTasks);
        this.sendResponse(scheduledTasks);
    }

    @Override
    protected String decodeClientMessage(ClientMessage clientMessage) {
        return ScheduledExecutorGetAllScheduledFuturesCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ScheduledExecutorGetAllScheduledFuturesCodec.encodeResponse((Collection)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:scheduledExecutorService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new ScheduledExecutorPermission((String)this.parameters, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return (String)this.parameters;
    }

    @Override
    public String getMethodName() {
        return "getAllScheduled";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.parameters};
    }

    private void retrieveAllMemberOwnedScheduled(List<ScheduledTaskHandler> accumulator) {
        try {
            InvokeOnMembers invokeOnMembers = new InvokeOnMembers(this.nodeEngine, this.getServiceName(), new GetAllScheduledOnMemberOperationFactory((String)this.parameters), this.nodeEngine.getClusterService().getMembers());
            this.accumulateTaskHandlersAsUrnValues(accumulator, invokeOnMembers.invoke());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private void retrieveAllPartitionOwnedScheduled(List<ScheduledTaskHandler> accumulator) {
        try {
            this.accumulateTaskHandlersAsUrnValues(accumulator, this.nodeEngine.getOperationService().invokeOnAllPartitions(this.getServiceName(), new GetAllScheduledOnPartitionOperationFactory((String)this.parameters)));
        }
        catch (Throwable t2) {
            throw ExceptionUtil.rethrow(t2);
        }
    }

    private void accumulateTaskHandlersAsUrnValues(List<ScheduledTaskHandler> accumulator, Map<?, ?> taskHandlersMap) {
        ClusterService clusterService = this.nodeEngine.getClusterService();
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        for (Map.Entry<?, ?> entry : taskHandlersMap.entrySet()) {
            Object key = entry.getKey();
            MemberImpl owner = key instanceof Number ? clusterService.getMember(partitionService.getPartitionOwner((Integer)key)) : (MemberImpl)key;
            List handlers = (List)entry.getValue();
            for (ScheduledTaskHandler handler : handlers) {
                ScheduledTaskHandlerAccessor.setUuid(handler, owner.getUuid());
            }
            accumulator.addAll(handlers);
        }
    }

    private class GetAllScheduledOnMemberOperationFactory
    implements Supplier<Operation> {
        private final String schedulerName;

        GetAllScheduledOnMemberOperationFactory(String schedulerName) {
            this.schedulerName = schedulerName;
        }

        @Override
        public Operation get() {
            return new GetAllScheduledOnMemberOperation(this.schedulerName).setCallerUuid(ScheduledExecutorGetAllScheduledMessageTask.this.endpoint.getUuid());
        }
    }
}

