/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnKeysCodec;
import com.hazelcast.client.impl.protocol.task.AbstractMultiPartitionMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapExecuteOnKeysMessageTask
extends AbstractMultiPartitionMessageTask<MapExecuteOnKeysCodec.RequestParameters> {
    public MapExecuteOnKeysMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        EntryProcessor processor = (EntryProcessor)this.serializationService.toObject(((MapExecuteOnKeysCodec.RequestParameters)this.parameters).entryProcessor);
        MapOperationProvider operationProvider = this.getMapOperationProvider(((MapExecuteOnKeysCodec.RequestParameters)this.parameters).name);
        return operationProvider.createMultipleEntryOperationFactory(((MapExecuteOnKeysCodec.RequestParameters)this.parameters).name, new HashSet<Data>(((MapExecuteOnKeysCodec.RequestParameters)this.parameters).keys), processor);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        ArrayList<Map.Entry<Data, Data>> entries = new ArrayList<Map.Entry<Data, Data>>();
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        for (Object o : map.values()) {
            if (o == null) continue;
            MapEntries mapEntries = (MapEntries)mapService.getMapServiceContext().toObject(o);
            mapEntries.putAllToList(entries);
        }
        return entries;
    }

    @Override
    public PartitionIdSet getPartitions() {
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        int partitions = partitionService.getPartitionCount();
        PartitionIdSet partitionIds = new PartitionIdSet(partitions);
        Iterator<Data> iterator2 = ((MapExecuteOnKeysCodec.RequestParameters)this.parameters).keys.iterator();
        int addedPartitions = 0;
        while (iterator2.hasNext() && addedPartitions < partitions) {
            Data key = iterator2.next();
            if (!partitionIds.add(partitionService.getPartitionId(key))) continue;
            ++addedPartitions;
        }
        return partitionIds;
    }

    @Override
    protected MapExecuteOnKeysCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapExecuteOnKeysCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapExecuteOnKeysCodec.encodeResponse((List)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapExecuteOnKeysCodec.RequestParameters)this.parameters).name, "put", "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapExecuteOnKeysCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "executeOnKeys";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapExecuteOnKeysCodec.RequestParameters)this.parameters).keys, ((MapExecuteOnKeysCodec.RequestParameters)this.parameters).entryProcessor};
    }
}

