/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientCreateProxyCodec;
import com.hazelcast.client.impl.protocol.task.AbstractInvocationMessageTask;
import com.hazelcast.client.impl.protocol.task.BlockingMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.ActionConstants;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.proxyservice.ProxyService;
import com.hazelcast.spi.impl.proxyservice.impl.operations.InitializeDistributedObjectOperation;
import java.security.Permission;
import java.util.Collection;
import java.util.Iterator;

public class CreateProxyMessageTask
extends AbstractInvocationMessageTask<ClientCreateProxyCodec.RequestParameters>
implements BlockingMessageTask {
    public CreateProxyMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        if (!this.nodeEngine.getLocalMember().isLiteMember()) {
            return operationService.createInvocationBuilder(this.getServiceName(), op, this.nodeEngine.getThisAddress());
        }
        Collection<Member> members = this.nodeEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        Iterator<Member> iterator2 = members.iterator();
        if (iterator2.hasNext()) {
            Member member = iterator2.next();
            Address address = member.getAddress();
            return operationService.createInvocationBuilder(this.getServiceName(), op, address);
        }
        return operationService.createInvocationBuilder(this.getServiceName(), op, this.nodeEngine.getThisAddress());
    }

    @Override
    protected Operation prepareOperation() {
        return new InitializeDistributedObjectOperation(((ClientCreateProxyCodec.RequestParameters)this.parameters).serviceName, ((ClientCreateProxyCodec.RequestParameters)this.parameters).name);
    }

    @Override
    protected ClientCreateProxyCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ClientCreateProxyCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ClientCreateProxyCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return ((ClientCreateProxyCodec.RequestParameters)this.parameters).serviceName;
    }

    @Override
    public Permission getRequiredPermission() {
        ProxyService proxyService = this.clientEngine.getProxyService();
        if (proxyService.existsDistributedObject(((ClientCreateProxyCodec.RequestParameters)this.parameters).serviceName, ((ClientCreateProxyCodec.RequestParameters)this.parameters).name)) {
            return null;
        }
        return ActionConstants.getPermission(((ClientCreateProxyCodec.RequestParameters)this.parameters).name, ((ClientCreateProxyCodec.RequestParameters)this.parameters).serviceName, "create");
    }

    @Override
    public String getDistributedObjectName() {
        return ((ClientCreateProxyCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

