/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.config.DiskTierConfig;

public final class DiskTierConfigCodec {
    private static final int ENABLED_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 1;

    private DiskTierConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, DiskTierConfig diskTierConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[1]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, diskTierConfig.isEnabled());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, diskTierConfig.getDeviceName());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static DiskTierConfig decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        boolean enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        String deviceName = StringCodec.decode(iterator2);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createDiskTierConfig(enabled, deviceName);
    }
}

