/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.memory.Capacity;

public final class CapacityCodec {
    private static final int VALUE_FIELD_OFFSET = 0;
    private static final int UNIT_FIELD_OFFSET = 8;
    private static final int INITIAL_FRAME_SIZE = 12;

    private CapacityCodec() {
    }

    public static void encode(ClientMessage clientMessage, Capacity capacity) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[12]);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 0, capacity.getValue());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 8, capacity.getUnit());
        clientMessage.add(initialFrame);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static Capacity decode(ClientMessage.ForwardFrameIterator iterator2) {
        iterator2.next();
        ClientMessage.Frame initialFrame = iterator2.next();
        long value = FixedSizeTypesCodec.decodeLong(initialFrame.content, 0);
        int unit = FixedSizeTypesCodec.decodeInt(initialFrame.content, 8);
        CodecUtil.fastForwardToEndFrame(iterator2);
        return CustomTypeFactory.createCapacity(value, unit);
    }
}

