/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AnchorDataListHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.PagingPredicateHolderCodec;
import com.hazelcast.client.impl.protocol.codec.holder.AnchorDataListHolder;
import com.hazelcast.client.impl.protocol.codec.holder.PagingPredicateHolder;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;

public final class MapValuesWithPagingPredicateCodec {
    public static final int REQUEST_MESSAGE_TYPE = 79104;
    public static final int RESPONSE_MESSAGE_TYPE = 79105;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private MapValuesWithPagingPredicateCodec() {
    }

    public static ClientMessage encodeRequest(String name, PagingPredicateHolder predicate) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Map.ValuesWithPagingPredicate");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 79104);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        PagingPredicateHolderCodec.encode(clientMessage, predicate);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        iterator2.next();
        request.name = StringCodec.decode(iterator2);
        request.predicate = PagingPredicateHolderCodec.decode(iterator2);
        return request;
    }

    public static ClientMessage encodeResponse(Collection<Data> response, AnchorDataListHolder anchorDataList) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 79105);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, response, DataCodec::encode);
        AnchorDataListHolderCodec.encode(clientMessage, anchorDataList);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator2.next();
        response.response = ListMultiFrameCodec.decode(iterator2, DataCodec::decode);
        response.anchorDataList = AnchorDataListHolderCodec.decode(iterator2);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public List<Data> response;
        public AnchorDataListHolder anchorDataList;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public PagingPredicateHolder predicate;
    }
}

