/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ByteArrayCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;

public final class JetUploadJobMultipartCodec {
    public static final int REQUEST_MESSAGE_TYPE = 16650752;
    public static final int RESPONSE_MESSAGE_TYPE = 16650753;
    private static final int REQUEST_SESSION_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_CURRENT_PART_NUMBER_FIELD_OFFSET = 33;
    private static final int REQUEST_TOTAL_PART_NUMBER_FIELD_OFFSET = 37;
    private static final int REQUEST_PART_SIZE_FIELD_OFFSET = 41;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 45;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private JetUploadJobMultipartCodec() {
    }

    public static ClientMessage encodeRequest(UUID sessionId, int currentPartNumber, int totalPartNumber, byte[] partData, int partSize, String sha256Hex) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Jet.UploadJobMultipart");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[45], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16650752);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, sessionId);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 33, currentPartNumber);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 37, totalPartNumber);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 41, partSize);
        clientMessage.add(initialFrame);
        ByteArrayCodec.encode(clientMessage, partData);
        StringCodec.encode(clientMessage, sha256Hex);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.sessionId = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        request.currentPartNumber = FixedSizeTypesCodec.decodeInt(initialFrame.content, 33);
        request.totalPartNumber = FixedSizeTypesCodec.decodeInt(initialFrame.content, 37);
        request.partSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 41);
        request.partData = ByteArrayCodec.decode(iterator2);
        request.sha256Hex = StringCodec.decode(iterator2);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16650753);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public UUID sessionId;
        public int currentPartNumber;
        public int totalPartNumber;
        public byte[] partData;
        public int partSize;
        public String sha256Hex;
    }
}

