/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import javax.annotation.Nullable;

public final class JetAddJobStatusListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 16651008;
    public static final int RESPONSE_MESSAGE_TYPE = 16651009;
    private static final int REQUEST_JOB_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_LIGHT_JOB_COORDINATOR_FIELD_OFFSET = 24;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 41;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 42;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 30;
    private static final int EVENT_JOB_STATUS_JOB_ID_FIELD_OFFSET = 16;
    private static final int EVENT_JOB_STATUS_PREVIOUS_STATUS_FIELD_OFFSET = 24;
    private static final int EVENT_JOB_STATUS_NEW_STATUS_FIELD_OFFSET = 28;
    private static final int EVENT_JOB_STATUS_USER_REQUESTED_FIELD_OFFSET = 32;
    private static final int EVENT_JOB_STATUS_INITIAL_FRAME_SIZE = 33;
    private static final int EVENT_JOB_STATUS_MESSAGE_TYPE = 16651010;

    private JetAddJobStatusListenerCodec() {
    }

    public static ClientMessage encodeRequest(long jobId, @Nullable UUID lightJobCoordinator, boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Jet.AddJobStatusListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[42], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16651008);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, jobId);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 24, lightJobCoordinator);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 41, localOnly);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.jobId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.lightJobCoordinator = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 24);
        request.localOnly = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 41);
        return request;
    }

    public static ClientMessage encodeResponse(@Nullable UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[30], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16651009);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static UUID decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator2.next();
        return FixedSizeTypesCodec.decodeUUID(initialFrame.content, 13);
    }

    public static ClientMessage encodeJobStatusEvent(long jobId, int previousStatus, int newStatus, @Nullable String description, boolean userRequested) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[33], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 16651010);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, jobId);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, previousStatus);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 28, newStatus);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 32, userRequested);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, description, StringCodec::encode);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
            if (messageType == 16651010) {
                ClientMessage.Frame initialFrame = iterator2.next();
                long jobId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
                int previousStatus = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
                int newStatus = FixedSizeTypesCodec.decodeInt(initialFrame.content, 28);
                boolean userRequested = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 32);
                String description = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
                this.handleJobStatusEvent(jobId, previousStatus, newStatus, description, userRequested);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleJobStatusEvent(long var1, int var3, int var4, @Nullable String var5, boolean var6);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public long jobId;
        @Nullable
        public UUID lightJobCoordinator;
        public boolean localOnly;
    }
}

