/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.RingbufferStoreConfigHolderCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.RingbufferStoreConfigHolder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class DynamicConfigAddRingbufferConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1769984;
    public static final int RESPONSE_MESSAGE_TYPE = 1769985;
    private static final int REQUEST_CAPACITY_FIELD_OFFSET = 16;
    private static final int REQUEST_BACKUP_COUNT_FIELD_OFFSET = 20;
    private static final int REQUEST_ASYNC_BACKUP_COUNT_FIELD_OFFSET = 24;
    private static final int REQUEST_TIME_TO_LIVE_SECONDS_FIELD_OFFSET = 28;
    private static final int REQUEST_MERGE_BATCH_SIZE_FIELD_OFFSET = 32;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 36;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private DynamicConfigAddRingbufferConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, int capacity, int backupCount, int asyncBackupCount, int timeToLiveSeconds, String inMemoryFormat, @Nullable RingbufferStoreConfigHolder ringbufferStoreConfig, @Nullable String splitBrainProtectionName, String mergePolicy, int mergeBatchSize) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddRingbufferConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[36], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1769984);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, capacity);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, backupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, asyncBackupCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 28, timeToLiveSeconds);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 32, mergeBatchSize);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        StringCodec.encode(clientMessage, inMemoryFormat);
        CodecUtil.encodeNullable(clientMessage, ringbufferStoreConfig, RingbufferStoreConfigHolderCodec::encode);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        StringCodec.encode(clientMessage, mergePolicy);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.capacity = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.backupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.asyncBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.timeToLiveSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 28);
        request.mergeBatchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 32);
        request.name = StringCodec.decode(iterator2);
        request.inMemoryFormat = StringCodec.decode(iterator2);
        request.ringbufferStoreConfig = CodecUtil.decodeNullable(iterator2, RingbufferStoreConfigHolderCodec::decode);
        request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        request.mergePolicy = StringCodec.decode(iterator2);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1769985);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public int capacity;
        public int backupCount;
        public int asyncBackupCount;
        public int timeToLiveSeconds;
        public String inMemoryFormat;
        @Nullable
        public RingbufferStoreConfigHolder ringbufferStoreConfig;
        @Nullable
        public String splitBrainProtectionName;
        public String mergePolicy;
        public int mergeBatchSize;
    }
}

