/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.management;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.management.ClientConnectionProcessListener;
import com.hazelcast.client.impl.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.cluster.Address;
import com.hazelcast.internal.util.executor.PoolExecutorThreadFactory;
import com.hazelcast.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;

public final class ClientConnectionProcessListenerRunner {
    private final CopyOnWriteArrayList<ClientConnectionProcessListener> listeners;
    private final HazelcastClientInstanceImpl client;
    private final AtomicBoolean hasListeners;
    private volatile ILogger logger;
    private volatile ExecutorService executor;

    public ClientConnectionProcessListenerRunner(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.listeners = new CopyOnWriteArrayList();
        this.hasListeners = new AtomicBoolean(false);
    }

    public void addListener(ClientConnectionProcessListener listener) {
        if (this.hasListeners.compareAndSet(false, true)) {
            this.createLogger();
            this.createExecutor();
        }
        this.listeners.add(listener);
    }

    public void stop() {
        if (!this.hasListeners.get()) {
            return;
        }
        this.executor.shutdown();
        ClientExecutionServiceImpl.awaitExecutorTermination("connection-diagnostics", this.executor, this.logger);
    }

    public <A> void onAttemptingToConnectToTarget(Function<A, Address> addressTranslator, A target) {
        if (!this.hasListeners.get()) {
            return;
        }
        Address translatedAddress = this.translateAddress(addressTranslator, target, "attemptingToConnectToAddress");
        if (translatedAddress == null) {
            return;
        }
        this.callListeners(listener -> listener.attemptingToConnectToAddress(translatedAddress));
    }

    public <A> void onConnectionAttemptFailed(Function<A, Address> addressTranslator, A target) {
        if (!this.hasListeners.get()) {
            return;
        }
        Address translatedAddress = this.translateAddress(addressTranslator, target, "connectionAttemptFailed");
        if (translatedAddress == null) {
            return;
        }
        this.callListeners(listener -> listener.connectionAttemptFailed(translatedAddress));
    }

    public void onHostNotFound(String host) {
        if (!this.hasListeners.get()) {
            return;
        }
        this.callListeners(listener -> listener.hostNotFound(host));
    }

    public void onPossibleAddressesCollected(Collection<Address> addresses) {
        if (!this.hasListeners.get()) {
            return;
        }
        ArrayList<Address> addressesList = new ArrayList<Address>(addresses);
        this.callListeners(listener -> listener.possibleAddressesCollected(addressesList));
    }

    public void onPossibleAddressesCollected(List<Address> addresses) {
        if (!this.hasListeners.get()) {
            return;
        }
        this.callListeners(listener -> listener.possibleAddressesCollected(addresses));
    }

    public void onAuthenticationSuccess(Address address) {
        if (!this.hasListeners.get()) {
            return;
        }
        this.callListeners(listener -> listener.authenticationSuccess(address));
    }

    public void onCredentialsFailed(Address address) {
        if (!this.hasListeners.get()) {
            return;
        }
        this.callListeners(listener -> listener.credentialsFailed(address));
    }

    public void onClientNotAllowedInCluster(Address address) {
        if (!this.hasListeners.get()) {
            return;
        }
        this.callListeners(listener -> listener.clientNotAllowedInCluster(address));
    }

    public void onClusterConnectionFailed(String clusterName) {
        if (!this.hasListeners.get()) {
            return;
        }
        this.callListeners(listener -> listener.clusterConnectionFailed(clusterName));
    }

    public void onClusterConnectionSucceeded(String clusterName) {
        if (!this.hasListeners.get()) {
            return;
        }
        this.callListeners(listener -> listener.clusterConnectionSucceeded(clusterName));
    }

    public <A> void onRemoteClosedConnection(Function<A, Address> addressTranslator, A target) {
        if (!this.hasListeners.get()) {
            return;
        }
        Address translatedAddress = this.translateAddress(addressTranslator, target, "remoteClosedConnection");
        if (translatedAddress == null) {
            return;
        }
        this.callListeners(listener -> listener.remoteClosedConnection(translatedAddress));
    }

    private <A> Address translateAddress(Function<A, Address> addressTranslator, A target, String listenerMethodName) {
        try {
            return addressTranslator.apply(target);
        }
        catch (Throwable t2) {
            this.logger.finest("Failed to translate address, can't fire " + listenerMethodName + " event for target " + target, t2);
            return null;
        }
    }

    private void callListeners(Consumer<ClientConnectionProcessListener> consumer) {
        try {
            this.executor.execute(() -> {
                for (ClientConnectionProcessListener listener : this.listeners) {
                    try {
                        consumer.accept(listener);
                    }
                    catch (Throwable t2) {
                        this.logger.finest("Exception while running the listener " + listener, t2);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private void createLogger() {
        this.logger = this.client.getLoggingService().getLogger(ClientConnectionProcessListenerRunner.class);
    }

    private void createExecutor() {
        ClassLoader classLoader = this.client.getClientConfig().getClassLoader();
        this.executor = Executors.newSingleThreadExecutor(new PoolExecutorThreadFactory(this.client.getName() + ".connection-diagnostics-", classLoader));
    }
}

