/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.ClientEndpoint;
import com.hazelcast.client.impl.ClientEndpointStatistics;
import com.hazelcast.client.impl.ClientEndpointStatisticsManager;
import com.hazelcast.client.impl.ClientEndpointStatisticsSnapshot;
import com.hazelcast.internal.util.MapUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class ClientEndpointStatisticsManagerImpl
implements ClientEndpointStatisticsManager {
    private static final Function<String, ClientEndpointStatistics> STATS_CREATOR = key -> new ClientEndpointStatistics();
    private final ConcurrentHashMap<String, ClientEndpointStatistics> stats = new ConcurrentHashMap();
    private volatile long lastResetTime;

    @Override
    public void onEndpointAuthenticated(ClientEndpoint endpoint) {
        ClientEndpointStatistics stats = this.getStats(endpoint);
        stats.incrementConnectionsOpenedCount();
        stats.addClientVersion(endpoint.getClientVersion());
    }

    @Override
    public void onEndpointDestroyed(ClientEndpoint endpoint) {
        if (!endpoint.isAuthenticated()) {
            return;
        }
        ClientEndpointStatistics endpointStats = this.getStats(endpoint);
        endpointStats.incrementConnectionsClosedCount();
        long uptime = this.getUptime(System.currentTimeMillis(), endpoint);
        if (uptime > 0L) {
            endpointStats.incrementTotalConnectionDuration(uptime);
        }
        endpointStats.addClientVersion(endpoint.getClientVersion());
    }

    @Override
    public Map<String, ClientEndpointStatisticsSnapshot> getSnapshotsAndReset(Collection<ClientEndpoint> activeEndpoints) {
        long now = System.currentTimeMillis();
        for (ClientEndpoint endpoint : activeEndpoints) {
            if (!endpoint.isAuthenticated()) continue;
            ClientEndpointStatistics stat2 = this.getStats(endpoint);
            long uptime = this.getUptime(now, endpoint);
            if (uptime > 0L) {
                stat2.incrementTotalConnectionDuration(uptime);
            }
            stat2.addClientVersion(endpoint.getClientVersion());
        }
        Map<String, ClientEndpointStatisticsSnapshot> snapshots2 = MapUtil.createHashMap(this.stats.size());
        this.stats.forEach((clientType, stat) -> snapshots2.put((String)clientType, stat.getSnapshotAndReset()));
        this.lastResetTime = now;
        return snapshots2;
    }

    private long getUptime(long now, ClientEndpoint endpoint) {
        long creationTime = endpoint.getCreationTime();
        long referenceTime = Math.max(creationTime, this.lastResetTime);
        return now - referenceTime;
    }

    private ClientEndpointStatistics getStats(ClientEndpoint endpoint) {
        return this.stats.computeIfAbsent(endpoint.getClientType(), STATS_CREATOR);
    }
}

