/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.operation.CacheRemoveAllOperation;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import java.io.IOException;
import java.util.Set;

public class CacheRemoveAllOperationFactory
implements OperationFactory,
IdentifiedDataSerializable {
    private String name;
    private Set<Data> keys;
    private int completionId;

    public CacheRemoveAllOperationFactory() {
    }

    public CacheRemoveAllOperationFactory(String name, Set<Data> keys2, int completionId) {
        this.name = name;
        this.keys = keys2;
        this.completionId = completionId;
    }

    @Override
    public Operation createOperation() {
        return new CacheRemoveAllOperation(this.name, this.keys, this.completionId);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.completionId);
        out.writeInt(this.keys == null ? -1 : this.keys.size());
        if (this.keys != null) {
            for (Data key : this.keys) {
                IOUtil.writeData(out, key);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.completionId = in.readInt();
        int size = in.readInt();
        if (size == -1) {
            return;
        }
        this.keys = SetUtil.createHashSet(size);
        for (int i = 0; i < size; ++i) {
            this.keys.add(IOUtil.readData(in));
        }
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 35;
    }
}

