/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.Buffers;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractSinkConduit;
import org.xnio.conduits.ConduitWritableByteChannel;
import org.xnio.conduits.Conduits;
import org.xnio.conduits.MessageSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public final class MessageStreamSinkConduit
extends AbstractSinkConduit<MessageSinkConduit>
implements StreamSinkConduit {
    public MessageStreamSinkConduit(MessageSinkConduit next) {
        super(next);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source2, long count, ByteBuffer throughBuffer) throws IOException {
        return Conduits.transfer(source2, count, throughBuffer, this);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int remaining = src.remaining();
        return ((MessageSinkConduit)this.next).send(src) ? remaining : 0;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        long remaining = Buffers.remaining(srcs, offs, len);
        return ((MessageSinkConduit)this.next).send(srcs, offs, len) ? remaining : 0L;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }
}

