/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PacketOutputStream
extends OutputStream {
    private static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private static final int SEQNO_OFFSET = 3;
    private static final int HEADER_LENGTH = 4;
    private static final int MAX_SEQNO = 65535;
    OutputStream baseStream;
    byte[] byteBuffer;
    int position;
    int seqNo;
    boolean compress;

    public PacketOutputStream(OutputStream baseStream) {
        this.baseStream = baseStream;
        this.byteBuffer = new byte[1024];
        this.seqNo = -1;
    }

    public void setCompress(boolean value) {
        if (this.seqNo != -1) {
            throw new AssertionError((Object)"setCompress on already started packet is illegal");
        }
        this.compress = value;
    }

    public void startPacket(int seqNo) throws IOException {
        if (this.seqNo != -1) {
            throw new IOException("Last packet not finished");
        }
        this.seqNo = seqNo;
        this.position = 4;
    }

    public int getSeqNo() {
        return this.seqNo;
    }

    private void writeEmptyPacket(int seqNo) throws IOException {
        this.byteBuffer[0] = 0;
        this.byteBuffer[1] = 0;
        this.byteBuffer[2] = 0;
        this.byteBuffer[3] = (byte)seqNo;
        this.baseStream.write(this.byteBuffer, 0, 4);
        this.position = 4;
    }

    public void sendFile(InputStream is, int seq) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = is.read(buffer)) > 0) {
            this.startPacket(seq++);
            this.write(buffer, 0, len);
            this.finishPacket();
        }
        this.writeEmptyPacket(seq);
    }

    public void finishPacket() throws IOException {
        if (this.seqNo == -1) {
            throw new AssertionError((Object)"Packet not started");
        }
        this.internalFlush();
        this.baseStream.flush();
        this.seqNo = -1;
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        if (this.seqNo == -1) {
            throw new AssertionError((Object)"Use PacketOutputStream.startPacket() before write()");
        }
        if (this.seqNo == 65535) {
            throw new IOException("MySQL protocol limit reached, you cannot send more than 4GB of data");
        }
        while (len != 0) {
            int bytesToWrite = Math.min(len, 0x1000003 - this.position);
            if (this.byteBuffer.length - this.position < bytesToWrite) {
                byte[] tmp = new byte[Math.min(0x1000003, 2 * (this.byteBuffer.length + bytesToWrite))];
                System.arraycopy(this.byteBuffer, 0, tmp, 0, this.position);
                this.byteBuffer = tmp;
            }
            System.arraycopy(bytes, off, this.byteBuffer, this.position, bytesToWrite);
            this.position += bytesToWrite;
            off += bytesToWrite;
            len -= bytesToWrite;
            if (this.position != 0x1000003) continue;
            this.internalFlush();
        }
    }

    @Override
    public void flush() throws IOException {
        throw new AssertionError((Object)"Do not call flush() on PacketOutputStream. use finishPacket() instead.");
    }

    private void internalFlush() throws IOException {
        int dataLen = this.position - 4;
        this.byteBuffer[0] = (byte)(dataLen & 0xFF);
        this.byteBuffer[1] = (byte)(dataLen >> 8 & 0xFF);
        this.byteBuffer[2] = (byte)(dataLen >> 16 & 0xFF);
        this.byteBuffer[3] = (byte)this.seqNo;
        this.baseStream.write(this.byteBuffer, 0, this.position);
        this.position = 4;
        ++this.seqNo;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] a = new byte[]{(byte)b};
        this.write(a);
    }

    @Override
    public void close() throws IOException {
        this.baseStream.close();
        this.byteBuffer = null;
    }
}

