/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.url;

import com.networknt.utility.StringUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryString {
    private static final long serialVersionUID = 1744232652147275170L;
    private final String encoding;
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();

    public QueryString() {
        this("", StandardCharsets.UTF_8.toString());
    }

    public QueryString(URL urlWithQueryString) {
        this(urlWithQueryString.toString(), null);
    }

    public QueryString(URL urlWithQueryString, String encoding) {
        this(urlWithQueryString.toString(), encoding);
    }

    public QueryString(String urlWithQueryString) {
        this(urlWithQueryString, null);
    }

    public QueryString(String urlWithQueryString, String encoding) {
        this.encoding = StringUtils.isBlank(encoding) ? StandardCharsets.UTF_8.toString() : encoding;
        String paramString = urlWithQueryString;
        if (paramString.contains("?")) {
            paramString = StringUtils.substringBefore(paramString, "#");
            paramString = paramString.replaceAll("(.*?)(\\?)(.*)", "$3");
        }
        String[] paramParts = paramString.split("\\&");
        for (int i = 0; i < paramParts.length; ++i) {
            String value;
            String key;
            String paramPart = paramParts[i];
            if (StringUtils.isBlank(paramPart)) continue;
            if (paramPart.contains("=")) {
                key = StringUtils.substringBefore(paramPart, "=");
                value = StringUtils.substringAfter(paramPart, "=");
            } else {
                key = paramPart;
                value = "";
            }
            try {
                this.addString(URLDecoder.decode(key, this.encoding), URLDecoder.decode(value, this.encoding));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Cannot URL-decode query string (key=" + key + "; value=" + value + ").", e);
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public synchronized String toString() {
        if (this.parameters.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int sep = 63;
        for (String key : this.parameters.keySet()) {
            for (String value : this.parameters.get(key)) {
                b.append((char)sep);
                sep = 38;
                try {
                    b.append(URLEncoder.encode(key, this.encoding));
                    b.append('=');
                    b.append(URLEncoder.encode(value, this.encoding));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Cannot URL-encode query string (key=" + key + "; value=" + value + ").", e);
                }
            }
        }
        return b.toString();
    }

    public String applyOnURL(String url) {
        if (StringUtils.isBlank(url)) {
            return url;
        }
        return StringUtils.substringBefore(url, "?") + this.toString();
    }

    public URL applyOnURL(URL url) {
        if (url == null) {
            return url;
        }
        try {
            return new URL(this.applyOnURL(url.toString()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot applyl query string to: " + url, e);
        }
    }

    public final void addString(String key, String ... values2) {
        if (values2 == null || Array.getLength(values2) == 0) {
            return;
        }
        List<String> list = this.parameters.get(key);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.addAll(Arrays.asList(values2));
        this.parameters.put(key, list);
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }
}

