/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server;

import com.networknt.config.Config;
import com.networknt.config.TlsUtil;
import com.networknt.handler.Handler;
import com.networknt.handler.HandlerProvider;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.OrchestrationHandler;
import com.networknt.registry.Registry;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.server.DefaultConfigLoader;
import com.networknt.server.DummyTrustManager;
import com.networknt.server.IConfigLoader;
import com.networknt.server.ServerConfig;
import com.networknt.server.ServerOption;
import com.networknt.server.ShutdownHookProvider;
import com.networknt.server.StartupHookProvider;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.Status;
import com.networknt.switcher.SwitcherUtil;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.NetUtils;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;

public class Server {
    static final Logger logger = LoggerFactory.getLogger(Server.class);
    public static final String SECRET_CONFIG_NAME = "secret";
    public static final String STARTUP_CONFIG_NAME = "startup";
    public static final String CONFIG_LOADER_CLASS = "configLoaderClass";
    public static final String[] STATUS_CONFIG_NAME = new String[]{"status", "app-status"};
    public static final String ENV_PROPERTY_KEY = "environment";
    public static final String ERROR_CONNECT_REGISTRY = "ERR10058";
    public static final String STATUS_HOST_IP = "STATUS_HOST_IP";
    static final String SID = "sId";
    public static int currentHttpPort = -1;
    public static int currentHttpsPort = -1;
    public static String currentAddress;
    public static final TrustManager[] TRUST_ALL_CERTS;
    public static List<String> serviceIds;
    public static List<URL> serviceUrls;
    protected static boolean shutdownRequested;
    static Undertow server;
    static Registry registry;
    static SSLContext sslContext;
    static GracefulShutdownHandler gracefulShutdownHandler;
    private static Set usedPorts;

    public static void main(String[] args2) {
        Server.init();
    }

    public static void init() {
        logger.info("server starts");
        System.setProperty("org.jboss.logging.provider", "slf4j");
        try {
            Server.loadConfigs();
            Server.mergeStatusConfig();
            ArrayList<String> masks = new ArrayList<String>();
            masks.add("keystorePass");
            masks.add("keyPass");
            masks.add("truststorePass");
            masks.add("bootstrapStorePass");
            ModuleRegistry.registerModule("server", Server.class.getName(), Config.getInstance().getJsonMapConfigNoCache("server"), masks);
            Server.start();
        }
        catch (RuntimeException e) {
            logger.error("Server is not operational! Failed with exception", e);
            System.out.println("Failed to start server:" + e.getMessage());
            System.exit(1);
        }
    }

    public static void loadConfigs() {
        IConfigLoader configLoader;
        Map<String, Object> startupConfig = Config.getInstance().getJsonMapConfig(STARTUP_CONFIG_NAME);
        if (startupConfig == null || startupConfig.get(CONFIG_LOADER_CLASS) == null) {
            configLoader = new DefaultConfigLoader();
        } else {
            try {
                Class<?> clazz = Class.forName((String)startupConfig.get(CONFIG_LOADER_CLASS));
                configLoader = (IConfigLoader)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("configLoaderClass mentioned in startup.yml could not be found or constructed", e);
            }
        }
        configLoader.init();
    }

    public static void start() {
        Server.addDaemonShutdownHook();
        StartupHookProvider[] startupHookProviders = SingletonServiceFactory.getBeans(StartupHookProvider.class);
        if (startupHookProviders != null) {
            Arrays.stream(startupHookProviders).forEach(s2 -> s2.onStartup());
        }
        if (Handler.config == null || !Handler.config.isEnabled()) {
            HttpHandler handler = Server.middlewareInit();
            gracefulShutdownHandler = new GracefulShutdownHandler(handler);
        } else {
            Handler.init();
            gracefulShutdownHandler = new GracefulShutdownHandler(new OrchestrationHandler());
        }
        ServerConfig serverConfig = ServerConfig.getInstance();
        if (serverConfig.dynamicPort) {
            if (serverConfig.minPort > serverConfig.maxPort) {
                String errMessage = "No ports available to bind to - the minPort is larger than the maxPort in server.yml";
                System.out.println(errMessage);
                logger.error(errMessage);
                throw new RuntimeException(errMessage);
            }
            int capacity = serverConfig.maxPort - serverConfig.minPort + 1;
            usedPorts = new HashSet(capacity);
            while (usedPorts.size() < capacity) {
                int randomPort = ThreadLocalRandom.current().nextInt(serverConfig.minPort, serverConfig.maxPort + 1);
                if (usedPorts.contains(randomPort)) continue;
                boolean b = Server.bind(gracefulShutdownHandler, randomPort);
                if (b) {
                    usedPorts = null;
                    break;
                }
                usedPorts.add(randomPort);
            }
        } else {
            Server.bind(gracefulShutdownHandler, -1);
        }
    }

    private static HttpHandler middlewareInit() {
        HttpHandler handler = null;
        HandlerProvider handlerProvider = SingletonServiceFactory.getBean(HandlerProvider.class);
        if (handlerProvider != null) {
            handler = handlerProvider.getHandler();
        }
        if (handler == null) {
            logger.error("Unable to start the server - no route handler provider available in service.yml");
            throw new RuntimeException("Unable to start the server - no route handler provider available in service.yml");
        }
        MiddlewareHandler[] middlewareHandlers = SingletonServiceFactory.getBeans(MiddlewareHandler.class);
        if (middlewareHandlers != null) {
            for (int i = middlewareHandlers.length - 1; i >= 0; --i) {
                logger.info("Plugin: " + middlewareHandlers[i].getClass().getName());
                if (!middlewareHandlers[i].isEnabled()) continue;
                handler = middlewareHandlers[i].setNext(handler);
                middlewareHandlers[i].register();
            }
        }
        return handler;
    }

    private static void serverOptionInit() {
        ServerOption.serverOptionInit(ServerConfig.getInstance().getMappedConfig(), ServerConfig.getInstance());
    }

    private static boolean bind(HttpHandler handler, int port) {
        ServerConfig serverConfig = ServerConfig.getInstance();
        try {
            int p;
            Undertow.Builder builder = Undertow.builder();
            if (serverConfig.enableHttps) {
                p = port < 0 ? serverConfig.getHttpsPort() : port;
                sslContext = Server.createSSLContext();
                builder.addHttpsListener(p, serverConfig.getIp(), sslContext);
                currentHttpsPort = p;
            }
            if (serverConfig.enableHttp) {
                p = port < 0 ? serverConfig.getHttpPort() : port;
                builder.addHttpListener(p, serverConfig.getIp());
                currentHttpPort = p;
            }
            if (currentHttpsPort == -1 && currentHttpPort == -1) {
                throw new RuntimeException("Unable to start the server as both http and https are disabled in server.yml");
            }
            if (serverConfig.enableHttp2) {
                builder.setServerOption(UndertowOptions.ENABLE_HTTP2, true);
            }
            if (serverConfig.isEnableTwoWayTls()) {
                builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, SslClientAuthMode.REQUIRED);
            }
            Server.serverOptionInit();
            server = builder.setBufferSize(serverConfig.getBufferSize()).setIoThreads(serverConfig.getIoThreads()).setSocketOption(Options.BACKLOG, serverConfig.getBacklog()).setServerOption(UndertowOptions.SHUTDOWN_TIMEOUT, serverConfig.getShutdownTimeout()).setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, false).setServerOption(UndertowOptions.ALWAYS_SET_DATE, serverConfig.isAlwaysSetDate()).setServerOption(UndertowOptions.RECORD_REQUEST_START_TIME, false).setServerOption(UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, serverConfig.isAllowUnescapedCharactersInUrl()).setSocketOption(Options.SSL_ENABLED_PROTOCOLS, Sequence.of(new String[]{"TLSv1.2"})).setServerOption(UndertowOptions.MAX_ENTITY_SIZE, serverConfig.getMaxTransferFileSize()).setServerOption(UndertowOptions.MULTIPART_MAX_ENTITY_SIZE, 10L * serverConfig.getMaxTransferFileSize()).setHandler(Handlers.header(handler, "Server", serverConfig.getServerString())).setWorkerThreads(serverConfig.getWorkerThreads()).build();
            server.start();
            System.out.println("HOST IP " + System.getenv(STATUS_HOST_IP));
        }
        catch (Exception e) {
            if (!serverConfig.dynamicPort || usedPorts.size() >= serverConfig.maxPort - serverConfig.minPort) {
                String triedPortsMessage = serverConfig.dynamicPort ? serverConfig.minPort + " to " + serverConfig.maxPort : "" + port;
                String errMessage = "No ports available to bind to. Tried: " + triedPortsMessage;
                System.out.println(errMessage);
                logger.error(errMessage);
                throw new RuntimeException(errMessage, e);
            }
            System.out.println("Failed to bind to port " + port++ + ". Trying " + port);
            if (logger.isInfoEnabled()) {
                logger.info("Failed to bind to port " + port++ + ". Trying " + port);
            }
            return false;
        }
        currentAddress = Server.getAddress();
        if (serverConfig.enableRegistry) {
            serviceUrls = new ArrayList<URL>();
            serviceUrls.add(Server.register(serverConfig.getServiceId()));
            if (serviceIds.size() > 0) {
                for (String id : serviceIds) {
                    serviceUrls.add(Server.register(id));
                }
            }
            SwitcherUtil.setSwitcherValue("RegistryHeartBeat", true);
            if (logger.isInfoEnabled()) {
                logger.info("Registry heart beat switcher is on");
            }
        }
        if (serverConfig.enableHttp) {
            System.out.println("Http Server started on ip:" + serverConfig.getIp() + " with HTTP Port:" + currentHttpPort);
            if (logger.isInfoEnabled()) {
                logger.info("Http Server started on ip:" + serverConfig.getIp() + " with HTTP Port:" + currentHttpPort);
            }
        } else {
            System.out.println("Http port disabled.");
            if (logger.isInfoEnabled()) {
                logger.info("Http port disabled.");
            }
        }
        if (serverConfig.enableHttps) {
            System.out.println("Https Server started on ip:" + serverConfig.getIp() + " with HTTPS Port:" + currentHttpsPort);
            if (logger.isInfoEnabled()) {
                logger.info("Https Server started on ip:" + serverConfig.getIp() + " with HTTPS Port:" + currentHttpsPort);
            }
        } else {
            System.out.println("Https port disabled.");
            if (logger.isInfoEnabled()) {
                logger.info("Https port disabled.");
            }
        }
        logger.info("ProductName = " + Server.getLight4jProduct() + " ProductVersion = " + Server.getLight4jVersion() + " ServiceId = " + serverConfig.getServiceId() + " Environment = " + serverConfig.getEnvironment());
        return true;
    }

    public static void shutdownApp(String[] args2) {
        Server.shutdown();
    }

    public static void stop() {
        if (server != null) {
            server.stop();
        }
    }

    public static void shutdown() {
        ShutdownHookProvider[] shutdownHookProviders;
        if (ServerConfig.getInstance().enableRegistry && registry != null && serviceUrls != null) {
            for (URL serviceUrl : serviceUrls) {
                registry.unregister(serviceUrl);
                System.out.println("unregister serviceUrl " + serviceUrl);
                if (!logger.isInfoEnabled()) continue;
                logger.info("unregister serviceUrl " + serviceUrl);
            }
        }
        if (gracefulShutdownHandler != null) {
            logger.info("Starting graceful shutdown.");
            gracefulShutdownHandler.shutdown();
            try {
                gracefulShutdownHandler.awaitShutdown(ServerConfig.getInstance().getShutdownGracefulPeriod());
            }
            catch (InterruptedException e) {
                logger.error("Error occurred while waiting for pending requests to complete.", e);
            }
            logger.info("Graceful shutdown complete.");
        }
        if ((shutdownHookProviders = SingletonServiceFactory.getBeans(ShutdownHookProvider.class)) != null) {
            Arrays.stream(shutdownHookProviders).forEach(s2 -> s2.onShutdown());
        }
        Server.stop();
        logger.info("Cleaning up before server shutdown");
    }

    protected static void addDaemonShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Server.shutdown();
            }
        });
    }

    protected static KeyStore loadKeyStore() {
        String name = ServerConfig.getInstance().getKeystoreName();
        String pass = ServerConfig.getInstance().getKeystorePass();
        if (pass == null) {
            Map<String, Object> secretConfig = Config.getInstance().getJsonMapConfig(SECRET_CONFIG_NAME);
            pass = (String)secretConfig.get("serverKeystorePass");
        }
        return TlsUtil.loadKeyStore(name, pass.toCharArray());
    }

    protected static KeyStore loadTrustStore() {
        String name = ServerConfig.getInstance().getTruststoreName();
        String pass = ServerConfig.getInstance().getTruststorePass();
        if (pass == null) {
            Map<String, Object> secretConfig = Config.getInstance().getJsonMapConfig(SECRET_CONFIG_NAME);
            pass = (String)secretConfig.get("serverTruststorePass");
        }
        return TlsUtil.loadTrustStore(name, pass.toCharArray());
    }

    private static TrustManager[] buildTrustManagers(KeyStore trustStore) {
        TrustManager[] trustManagers = null;
        if (trustStore != null) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(trustStore);
                trustManagers = trustManagerFactory.getTrustManagers();
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                logger.error("Unable to initialise TrustManager[]", e);
                throw new RuntimeException("Unable to initialise TrustManager[]", e);
            }
        } else {
            trustManagers = TRUST_ALL_CERTS;
        }
        return trustManagers;
    }

    private static KeyManager[] buildKeyManagers(KeyStore keyStore, char[] keyPass) {
        KeyManager[] keyManagers;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keyPass);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            logger.error("Unable to initialise KeyManager[]", e);
            throw new RuntimeException("Unable to initialise KeyManager[]", e);
        }
        return keyManagers;
    }

    private static SSLContext createSSLContext() throws RuntimeException {
        try {
            String keyPass = ServerConfig.getInstance().getKeyPass();
            if (keyPass == null) {
                Map<String, Object> secretConfig = Config.getInstance().getJsonMapConfig(SECRET_CONFIG_NAME);
                keyPass = (String)secretConfig.get("serverKeyPass");
            }
            KeyManager[] keyManagers = Server.buildKeyManagers(Server.loadKeyStore(), keyPass.toCharArray());
            TrustManager[] trustManagers = ServerConfig.getInstance().isEnableTwoWayTls() ? Server.buildTrustManagers(Server.loadTrustStore()) : Server.buildTrustManagers(null);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            logger.error("Unable to create SSLContext", e);
            throw new RuntimeException("Unable to create SSLContext", e);
        }
    }

    protected static void mergeStatusConfig() {
        Map<String, Object> appStatusConfig = Config.getInstance().getJsonMapConfigNoCache(STATUS_CONFIG_NAME[1]);
        if (appStatusConfig == null) {
            return;
        }
        Map<String, Object> statusConfig = Config.getInstance().getJsonMapConfig(STATUS_CONFIG_NAME[0]);
        HashSet<String> duplicatedStatusSet = new HashSet<String>(statusConfig.keySet());
        duplicatedStatusSet.retainAll(appStatusConfig.keySet());
        if (!duplicatedStatusSet.isEmpty()) {
            logger.error("The status code(s): " + ((Object)duplicatedStatusSet).toString() + " is already in use by light-4j and cannot be overwritten, please change to another status code in app-status.yml if necessary.");
            throw new RuntimeException("The status code(s): " + ((Object)duplicatedStatusSet).toString() + " in status.yml and app-status.yml are duplicated.");
        }
        statusConfig.putAll(appStatusConfig);
    }

    @Deprecated
    public static ServerConfig getServerConfig() {
        return ServerConfig.getInstance();
    }

    public static URL register(String serviceId) {
        URLImpl serviceUrl = null;
        try {
            registry = SingletonServiceFactory.getBean(Registry.class);
            if (registry == null) {
                throw new RuntimeException("Could not find registry instance in service map");
            }
            ServerConfig serverConfig = ServerConfig.getInstance();
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (serverConfig.getEnvironment() != null) {
                parameters.put(ENV_PROPERTY_KEY, serverConfig.getEnvironment());
            }
            serviceUrl = new URLImpl(serverConfig.enableHttps ? "https" : "http", currentAddress, serverConfig.enableHttps ? currentHttpsPort : currentHttpPort, serviceId, parameters);
            if (logger.isInfoEnabled()) {
                logger.info("register service: " + serviceUrl.toFullStr());
            }
            registry.register(serviceUrl);
            return serviceUrl;
        }
        catch (Exception e) {
            Status status = new Status(ERROR_CONNECT_REGISTRY, serviceUrl);
            if (ServerConfig.getInstance().startOnRegistryFailure) {
                System.out.println("Failed to register service, start the server without registry. ");
                System.out.println(status.toString());
                e.printStackTrace();
                if (logger.isInfoEnabled()) {
                    logger.info("Failed to register service, start the server without registry.", e);
                }
                return null;
            }
            System.out.println("Failed to register service, the server stopped.");
            System.out.println(status.toString());
            e.printStackTrace();
            if (logger.isInfoEnabled()) {
                logger.info("Failed to register service, the server stopped.", e);
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String getAddress() {
        String address = System.getenv(STATUS_HOST_IP);
        logger.info("Registry IP from STATUS_HOST_IP is " + address);
        if (address == null) {
            InetAddress inetAddress = NetUtils.getLocalAddress();
            address = inetAddress.getHostAddress();
            logger.info("Could not find IP from STATUS_HOST_IP, use the InetAddress " + address);
        }
        return address;
    }

    public static String getLight4jVersion() {
        return Server.class.getPackage().getImplementationVersion();
    }

    public static String getLight4jProduct() {
        return Server.class.getPackage().getImplementationTitle();
    }

    static {
        TRUST_ALL_CERTS = new X509TrustManager[]{new DummyTrustManager()};
        serviceIds = new ArrayList<String>();
        shutdownRequested = false;
        server = null;
    }
}

