/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jaeger.tracing;

import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.Map;

public class JaegerConfig {
    public static final String CONFIG_NAME = "jaeger-tracing";
    public static final String ENABLED = "enabled";
    public static final String TYPE = "type";
    public static final String PARAM = "param";
    boolean enabled;
    String type;
    Number param;
    private final Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    private JaegerConfig() {
        this(CONFIG_NAME);
    }

    private JaegerConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
    }

    public static JaegerConfig load() {
        return new JaegerConfig();
    }

    public static JaegerConfig load(String configName) {
        return new JaegerConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Number getParam() {
        return this.param;
    }

    public void setParam(Number param) {
        this.param = param;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(ENABLED);
        if (object != null) {
            this.enabled = Config.loadBooleanValue(ENABLED, object);
        }
        if ((object = this.mappedConfig.get(TYPE)) != null) {
            this.type = (String)object;
        }
        if ((object = this.mappedConfig.get(PARAM)) != null) {
            if (object instanceof Number) {
                this.param = (Number)object;
            } else if (object instanceof String) {
                this.param = ((String)object).indexOf(46) == -1 ? (Number)Integer.valueOf((String)object) : (Number)Double.valueOf((String)object);
            } else {
                throw new ConfigException("param must be an integer or a double or a string value.");
            }
        }
    }
}

