/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.http.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class JsonMapper {
    public static ObjectMapper objectMapper = new ObjectMapper();

    public static String toJson(Object x) {
        try {
            return objectMapper.writeValueAsString(x);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromJson(String json, Class<T> targetType) {
        try {
            return objectMapper.readValue(json, targetType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> string2Map(String s2) {
        try {
            return objectMapper.readValue(s2, new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Map<String, Object>> string2List(String s2) {
        try {
            return objectMapper.readValue(s2, new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        objectMapper.configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.registerModule(new JavaTimeModule());
    }
}

