/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.http;

import com.networknt.client.http.BodyPart;
import com.networknt.common.ContentType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class HttpRequestValue
implements Serializable {
    private Map<String, BodyPart> bodyPartMap;
    private ContentType contentType;

    public HttpRequestValue() {
        this(null);
    }

    public HttpRequestValue(ContentType contentType) {
        this(contentType, null);
    }

    public HttpRequestValue(ContentType contentType, Map<String, BodyPart> bodyPartMap) {
        this.bodyPartMap = bodyPartMap;
    }

    public void setBody(Map<String, BodyPart> bodyPartMap) {
        this.bodyPartMap = bodyPartMap;
    }

    public Map<String, BodyPart> getBody() {
        return this.bodyPartMap;
    }

    public BodyPart getBody(String key) {
        return this.bodyPartMap == null ? null : this.bodyPartMap.get(key);
    }

    public boolean hasBody(String key) {
        return this.bodyPartMap == null ? false : this.bodyPartMap.containsKey(key);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        builder.append(',');
        Map<String, BodyPart> body = this.getBody();
        if (body != null) {
            builder.append(body);
            builder.append(',');
        }
        builder.append('>');
        return builder.toString();
    }

    public static DefaultRequestValueBuilder builder() {
        return new DefaultRequestValueBuilder();
    }

    public static DefaultRequestValueBuilder builder(ContentType contentType) {
        return new DefaultRequestValueBuilder(contentType);
    }

    public static class DefaultRequestValueBuilder {
        private Map<String, BodyPart> mappings = new HashMap<String, BodyPart>();
        private ContentType contentType;

        public DefaultRequestValueBuilder() {
        }

        public DefaultRequestValueBuilder(ContentType contentType) {
            this.contentType = contentType;
        }

        public DefaultRequestValueBuilder with(String name, ContentType type, Object body) {
            this.mappings.put(name, new BodyPart<Object>(type, body));
            return this;
        }

        public HttpRequestValue build() {
            return new HttpRequestValue(this.contentType, this.mappings);
        }
    }
}

