/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.internal.util.ConcurrencyDetection;
import com.hazelcast.internal.util.ThreadLocalRandomProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.UrgentSystemOperation;
import com.hazelcast.spi.impl.sequence.CallIdFactory;
import com.hazelcast.spi.impl.sequence.CallIdSequence;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class BackpressureRegulator {
    static final float RANGE = 0.25f;
    private final AtomicInteger syncCountdown = new AtomicInteger();
    private final boolean enabled;
    private final boolean disabled;
    private final int syncWindow;
    private final int partitionCount;
    private final int maxConcurrentInvocations;
    private final int backoffTimeoutMs;

    BackpressureRegulator(HazelcastProperties properties, ILogger logger2) {
        this.enabled = properties.getBoolean(ClusterProperty.BACKPRESSURE_ENABLED);
        this.disabled = !this.enabled;
        this.partitionCount = properties.getInteger(ClusterProperty.PARTITION_COUNT);
        this.syncWindow = this.getSyncWindow(properties);
        this.syncCountdown.set(this.syncWindow);
        this.maxConcurrentInvocations = this.getMaxConcurrentInvocations(properties);
        this.backoffTimeoutMs = this.getBackoffTimeoutMs(properties);
        if (this.enabled) {
            logger2.info("Backpressure is enabled, maxConcurrentInvocations:" + this.maxConcurrentInvocations + ", syncWindow: " + this.syncWindow);
            int backupTimeoutMillis = properties.getInteger(ClusterProperty.OPERATION_BACKUP_TIMEOUT_MILLIS);
            if ((long)backupTimeoutMillis < TimeUnit.MINUTES.toMillis(1L)) {
                logger2.warning(String.format("Back pressure is enabled, but '%s' is too small. ", ClusterProperty.OPERATION_BACKUP_TIMEOUT_MILLIS.getName()));
            }
        } else if (logger2.isFineEnabled()) {
            logger2.fine("Backpressure is disabled");
        }
    }

    int syncCountDown() {
        return this.syncCountdown.get();
    }

    private int getSyncWindow(HazelcastProperties props) {
        int syncWindow = props.getInteger(ClusterProperty.BACKPRESSURE_SYNCWINDOW);
        if (this.enabled && syncWindow <= 0) {
            throw new IllegalArgumentException("Can't have '" + ClusterProperty.BACKPRESSURE_SYNCWINDOW + "' with a value smaller than 1");
        }
        return syncWindow;
    }

    private int getBackoffTimeoutMs(HazelcastProperties props) {
        int backoffTimeoutMs = (int)props.getMillis(ClusterProperty.BACKPRESSURE_BACKOFF_TIMEOUT_MILLIS);
        if (this.enabled && backoffTimeoutMs < 0) {
            throw new IllegalArgumentException("Can't have '" + ClusterProperty.BACKPRESSURE_BACKOFF_TIMEOUT_MILLIS + "' with a value smaller than 0");
        }
        return backoffTimeoutMs;
    }

    private int getMaxConcurrentInvocations(HazelcastProperties props) {
        if (this.disabled) {
            return Integer.MAX_VALUE;
        }
        int invocationsPerPartition = props.getInteger(ClusterProperty.BACKPRESSURE_MAX_CONCURRENT_INVOCATIONS_PER_PARTITION);
        if (invocationsPerPartition < 1) {
            throw new IllegalArgumentException("Can't have '" + ClusterProperty.BACKPRESSURE_MAX_CONCURRENT_INVOCATIONS_PER_PARTITION + "' with a value smaller than 1");
        }
        return (this.partitionCount + 1) * invocationsPerPartition;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    int getMaxConcurrentInvocations() {
        if (this.enabled) {
            return this.maxConcurrentInvocations;
        }
        return Integer.MAX_VALUE;
    }

    CallIdSequence newCallIdSequence(ConcurrencyDetection concurrencyDetection) {
        return CallIdFactory.newCallIdSequence(this.maxConcurrentInvocations, this.backoffTimeoutMs, concurrencyDetection);
    }

    boolean isSyncForced(BackupAwareOperation backupAwareOp) {
        int current;
        if (this.disabled) {
            return false;
        }
        if (backupAwareOp.getAsyncBackupCount() == 0) {
            return false;
        }
        if (backupAwareOp instanceof UrgentSystemOperation) {
            return false;
        }
        do {
            if ((current = this.syncCountdown.decrementAndGet()) <= 0) continue;
            return false;
        } while (!this.syncCountdown.compareAndSet(current, this.randomSyncDelay()));
        return true;
    }

    private int randomSyncDelay() {
        if (this.syncWindow == 1) {
            return 1;
        }
        Random random = ThreadLocalRandomProvider.get();
        int randomSyncWindow = Math.round(0.75f * (float)this.syncWindow + (float)random.nextInt(Math.round(0.5f * (float)this.syncWindow)));
        return Math.max(1, randomSyncWindow);
    }
}

