/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.operation.ForcedEviction;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.memory.NativeOutOfMemoryError;

class SingleRecordStoreForcedEviction
implements ForcedEviction {
    SingleRecordStoreForcedEviction() {
    }

    @Override
    public boolean forceEvictAndRun(MapOperation mapOperation, double evictionPercentage) {
        return this.forceEvictAndRun0(mapOperation, evictionPercentage, null);
    }

    @Override
    public boolean forceEvictAndRun(MapOperation mapOperation, double evictionPercentage, Runnable runnable2) {
        return this.forceEvictAndRun0(mapOperation, evictionPercentage, runnable2);
    }

    private boolean forceEvictAndRun0(MapOperation mapOperation, double evictionPercentage, Runnable runnable2) {
        assert (evictionPercentage > 0.0 && evictionPercentage <= 1.0);
        RecordStore<Record> recordStore = mapOperation.recordStore;
        if (!ForcedEviction.isValid(recordStore)) {
            return false;
        }
        ILogger logger2 = mapOperation.logger();
        int retryCount = this.retryCount(evictionPercentage);
        for (int i = 0; i < retryCount; ++i) {
            if (logger2.isFineEnabled() && logger2.isFineEnabled()) {
                String msg = "Single record store forced eviction [attemptNumber: %d, mapName: %s, evictionPercentage:%.2f, partitionId: %d]";
                logger2.fine(String.format(msg, i + 1, mapOperation.getName(), evictionPercentage, mapOperation.getPartitionId()));
            }
            try {
                Evictor evictor = recordStore.getMapContainer().getEvictor();
                evictor.forceEvictByPercentage(recordStore, evictionPercentage);
                if (runnable2 != null) {
                    runnable2.run();
                } else {
                    mapOperation.runInternal();
                }
                return true;
            }
            catch (NativeOutOfMemoryError e) {
                EmptyStatement.ignore(e);
                continue;
            }
        }
        return false;
    }
}

