/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.MultipleRecordStoreForcedEviction;
import com.hazelcast.map.impl.operation.SingleRecordStoreForcedEviction;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public interface ForcedEviction {
    public static final int EVICTION_RETRY_COUNT = 5;
    public static final double TWENTY_PERCENT = 0.2;
    public static final double HUNDRED_PERCENT = 1.0;
    public static final double[] EVICTION_PERCENTAGES = new double[]{0.2, 1.0};
    public static final ForcedEviction[] EVICTION_STRATEGIES = new ForcedEviction[]{new SingleRecordStoreForcedEviction(), new MultipleRecordStoreForcedEviction()};

    public static void runWithForcedEvictionStrategies(MapOperation operation) {
        for (double evictionPercentage : EVICTION_PERCENTAGES) {
            for (ForcedEviction evictionStrategy : EVICTION_STRATEGIES) {
                if (!evictionStrategy.forceEvictAndRun(operation, evictionPercentage)) continue;
                return;
            }
        }
    }

    public static void runStepWithForcedEvictionStrategies(MapOperation mapOperation, Runnable runnable2) {
        for (double evictionPercentage : EVICTION_PERCENTAGES) {
            for (ForcedEviction evictionStrategy : EVICTION_STRATEGIES) {
                if (!evictionStrategy.forceEvictAndRun(mapOperation, evictionPercentage, runnable2)) continue;
                return;
            }
        }
    }

    public boolean forceEvictAndRun(MapOperation var1, double var2);

    public boolean forceEvictAndRun(MapOperation var1, double var2, @Nullable Runnable var4);

    public static boolean isValid(RecordStore recordStore) {
        return recordStore != null && recordStore.getInMemoryFormat() == InMemoryFormat.NATIVE && recordStore.getEvictionPolicy() != EvictionPolicy.NONE && recordStore.size() > 0;
    }

    default public int mod(MapOperation mapOperation, int threadCount) {
        return mapOperation.getPartitionId() % threadCount;
    }

    default public int threadCount(MapOperation mapOperation) {
        NodeEngine nodeEngine = mapOperation.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        return operationService.getPartitionThreadCount();
    }

    default public int numberOfPartitions(MapOperation mapOperation) {
        NodeEngine nodeEngine = mapOperation.getNodeEngine();
        return nodeEngine.getPartitionService().getPartitionCount();
    }

    default public ConcurrentMap<String, RecordStore> partitionMaps(MapOperation mapOperation, int partitionId) {
        return mapOperation.mapServiceContext.getPartitionContainer(partitionId).getMaps();
    }

    default public int retryCount(double evictionPercentage) {
        return evictionPercentage == 1.0 ? 1 : 5;
    }
}

