/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.util;

import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.shaded.io.github.classgraph.ClassGraph;
import com.hazelcast.shaded.io.github.classgraph.ClassInfo;
import com.hazelcast.shaded.io.github.classgraph.ScanResult;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Class<?> loadClass(String name) {
        return ReflectionUtils.loadClass(Thread.currentThread().getContextClassLoader(), name);
    }

    public static Class<?> loadClass(ClassLoader classLoaderHint, String name) {
        try {
            return ClassLoaderUtil.loadClass(classLoaderHint, name);
        }
        catch (ClassNotFoundException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static <T> T newInstance(ClassLoader classLoader, String name) {
        try {
            return ClassLoaderUtil.newInstance(classLoader, name);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static <T> T readStaticFieldOrNull(String className, String fieldName) {
        try {
            Class<?> clazz = Class.forName(className);
            return ReflectionUtils.readStaticField(clazz, fieldName);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | SecurityException e) {
            return null;
        }
    }

    private static <T> T readStaticField(Class<?> clazz, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = clazz.getDeclaredField(fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return (T)field.get(null);
    }

    @Nullable
    public static Method findPropertySetter(@Nonnull Class<?> clazz, @Nonnull String propertyName, @Nonnull Class<?> propertyType) {
        Method method;
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            method = clazz.getMethod(setterName, propertyType);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return null;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE && returnType != Void.class && returnType != clazz) {
            return null;
        }
        return method;
    }

    @Nullable
    public static Method findPropertySetter(@Nonnull Class<?> clazz, @Nonnull String propertyName) {
        Method setter = ReflectionUtils.findPropertyAccessor(clazz, propertyName, "set");
        if (setter == null) {
            return null;
        }
        Class<?> returnType = setter.getReturnType();
        if (returnType != Void.TYPE && returnType != Void.class && returnType != clazz) {
            return null;
        }
        return setter;
    }

    public static Method findPropertyGetter(@Nonnull Class<?> clazz, @Nonnull String propertyName) {
        Method getter = ReflectionUtils.findPropertyAccessor(clazz, propertyName, "get", "is");
        if (getter == null) {
            return null;
        }
        Class<?> returnType = getter.getReturnType();
        if (returnType == Void.TYPE || returnType == Void.class) {
            return null;
        }
        return getter;
    }

    private static Method findPropertyAccessor(@Nonnull Class<?> clazz, @Nonnull String propertyName, String ... prefixes) {
        Set accessorNames = Arrays.stream(prefixes).map(prefix -> prefix + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1)).collect(Collectors.toSet());
        Method method = Arrays.stream(clazz.getMethods()).filter(m4 -> accessorNames.contains(m4.getName())).findAny().orElse(null);
        if (method == null) {
            return null;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return null;
        }
        return method;
    }

    @Nullable
    public static Field findPropertyField(Class<?> clazz, String fieldName) {
        Field field;
        try {
            field = clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) {
            return null;
        }
        return field;
    }

    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive on try-with-resources as of JDK11")
    public static Collection<Class<?>> nestedClassesOf(Class<?> ... classes) {
        ClassGraph classGraph = new ClassGraph().enableClassInfo().ignoreClassVisibility();
        Arrays.stream(classes).map(Class::getClassLoader).distinct().forEach(classGraph::addClassLoader);
        Arrays.stream(classes).map(ReflectionUtils::toPackageName).distinct().forEach(xva$0 -> classGraph.whitelistPackages((String)xva$0));
        try (ScanResult scanResult = classGraph.scan();){
            Set classNames = Arrays.stream(classes).map(Class::getName).collect(Collectors.toSet());
            Collection collection = Stream.concat(Arrays.stream(classes), scanResult.getAllClasses().stream().filter(classInfo -> classNames.contains(classInfo.getName())).flatMap(classInfo -> classInfo.getInnerClasses().stream()).map(ClassInfo::loadClass)).collect(Collectors.toList());
            return collection;
        }
    }

    private static String toPackageName(Class<?> clazz) {
        return Optional.ofNullable(clazz.getPackage()).map(Package::getName).orElse("");
    }

    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive on try-with-resources as of JDK11")
    public static Resources resourcesOf(String ... packages) {
        String[] paths = (String[])Arrays.stream(packages).map(ReflectionUtils::toPath).toArray(String[]::new);
        ClassGraph classGraph = new ClassGraph().whitelistPackages(packages).whitelistPaths(paths).ignoreClassVisibility();
        try (ScanResult scanResult = classGraph.scan();){
            Collection classes = scanResult.getAllClasses().stream().map(x$0 -> new ClassResource((ClassInfo)x$0)).collect(Collectors.toList());
            List<URL> nonClasses = scanResult.getAllResources().nonClassFilesOnly().getURLs();
            Resources resources = new Resources(classes, nonClasses);
            return resources;
        }
    }

    private static String toPath(String name) {
        return name.replace('.', '/');
    }

    public static String toClassResourceId(String name) {
        return ReflectionUtils.toPath(name) + ".class";
    }

    public static Object getFieldValue(String fieldName, Object obj) {
        Field field;
        Method getter = ReflectionUtils.findPropertyGetter(obj.getClass(), fieldName);
        if (getter != null) {
            try {
                return getter.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        if ((field = ReflectionUtils.findPropertyField(obj.getClass(), fieldName)) == null) {
            return null;
        }
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException ignored) {
            return null;
        }
    }

    public static final class ClassResource {
        private final String id;
        private final URL url;

        private ClassResource(ClassInfo classInfo) {
            this(classInfo.getName(), classInfo.getResource().getURL());
        }

        public ClassResource(String name, URL url) {
            this.id = ReflectionUtils.toClassResourceId(name);
            this.url = url;
        }

        public String getId() {
            return this.id;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassResource that = (ClassResource)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.url, that.url);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.url);
        }
    }

    public static final class Resources {
        private final Collection<ClassResource> classes;
        private final Collection<URL> nonClasses;

        private Resources(Collection<ClassResource> classes, Collection<URL> nonClasses) {
            this.classes = classes;
            this.nonClasses = nonClasses;
        }

        public Stream<ClassResource> classes() {
            return this.classes.stream();
        }

        public Stream<URL> nonClasses() {
            return this.nonClasses.stream();
        }
    }
}

