/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.observer;

import com.hazelcast.jet.function.Observer;
import com.hazelcast.jet.impl.observer.WrappedThrowable;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nonnull;

public final class BlockingIteratorObserver<T>
implements Iterator<T>,
Observer<T> {
    private static final Object COMPLETED = new Object();
    private final BlockingQueue<Object> itemQueue = new LinkedBlockingQueue<Object>();
    private Object next;

    @Override
    public void onNext(@Nonnull T t2) {
        this.itemQueue.add(t2);
    }

    @Override
    public void onError(@Nonnull Throwable throwable) {
        this.itemQueue.add(WrappedThrowable.of(throwable));
    }

    @Override
    public void onComplete() {
        this.itemQueue.add(COMPLETED);
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.next = this.waitForNext();
        }
        if (this.next instanceof WrappedThrowable) {
            throw ExceptionUtil.rethrow(((WrappedThrowable)this.next).get());
        }
        return this.next != COMPLETED;
    }

    @Nonnull
    private Object waitForNext() {
        try {
            return this.itemQueue.take();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    @Nonnull
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object item = this.next;
        this.next = null;
        return (T)item;
    }
}

