/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.ComparatorEx;
import com.hazelcast.jet.config.EdgeConfig;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Partitioner;
import com.hazelcast.jet.impl.execution.init.CustomClassLoadedObject;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.execution.init.VertexDef;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;

public class EdgeDef
implements IdentifiedDataSerializable {
    private int oppositeVertexId;
    private int sourceOrdinal;
    private int destOrdinal;
    private int priority;
    private Edge.RoutingPolicy routingPolicy;
    private Partitioner<?> partitioner;
    private EdgeConfig config;
    private ComparatorEx<?> comparator;
    protected Address distributedTo;
    protected transient String id;
    protected transient VertexDef sourceVertex;
    protected transient VertexDef destVertex;

    EdgeDef() {
    }

    EdgeDef(Edge edge, EdgeConfig config, int oppositeVertexId, boolean isJobDistributed) {
        this.oppositeVertexId = oppositeVertexId;
        this.sourceOrdinal = edge.getSourceOrdinal();
        this.destOrdinal = edge.getDestOrdinal();
        this.priority = edge.getPriority();
        this.distributedTo = isJobDistributed ? edge.getDistributedTo() : null;
        this.routingPolicy = edge.getRoutingPolicy();
        this.partitioner = edge.getPartitioner();
        this.config = config;
        this.comparator = edge.getOrderComparator();
    }

    void initTransientFields(Map<Integer, VertexDef> vMap, VertexDef nearVertex, boolean isOutbound) {
        VertexDef farVertex = vMap.get(this.oppositeVertexId);
        this.sourceVertex = isOutbound ? nearVertex : farVertex;
        this.destVertex = isOutbound ? farVertex : nearVertex;
        this.id = this.sourceVertex.vertexId() + "-" + this.sourceOrdinal + ':' + this.destVertex.vertexId() + '-' + this.destOrdinal;
    }

    public Edge.RoutingPolicy routingPolicy() {
        return this.routingPolicy;
    }

    public Partitioner<?> partitioner() {
        return this.partitioner;
    }

    String edgeId() {
        return this.id;
    }

    VertexDef sourceVertex() {
        return this.sourceVertex;
    }

    int sourceOrdinal() {
        return this.sourceOrdinal;
    }

    VertexDef destVertex() {
        return this.destVertex;
    }

    int destOrdinal() {
        return this.destOrdinal;
    }

    int priority() {
        return this.priority;
    }

    boolean isSnapshotRestoreEdge() {
        return this.priority == Integer.MIN_VALUE;
    }

    boolean isLocal() {
        return this.distributedTo == null;
    }

    Address getDistributedTo() {
        return this.distributedTo;
    }

    EdgeConfig getConfig() {
        return this.config;
    }

    ComparatorEx<?> getOrderComparator() {
        return this.comparator;
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.oppositeVertexId);
        out.writeInt(this.destOrdinal);
        out.writeInt(this.sourceOrdinal);
        out.writeInt(this.priority);
        out.writeObject(this.distributedTo);
        out.writeString(this.routingPolicy == null ? null : this.routingPolicy.name());
        out.writeObject(this.config);
        CustomClassLoadedObject.write(out, this.partitioner);
        CustomClassLoadedObject.write(out, this.comparator);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.oppositeVertexId = in.readInt();
        this.destOrdinal = in.readInt();
        this.sourceOrdinal = in.readInt();
        this.priority = in.readInt();
        this.distributedTo = (Address)in.readObject();
        String routingPolicyName = in.readString();
        this.routingPolicy = routingPolicyName == null ? null : Edge.RoutingPolicy.valueOf(routingPolicyName);
        this.config = (EdgeConfig)in.readObject();
        this.partitioner = (Partitioner)CustomClassLoadedObject.read(in);
        this.comparator = (ComparatorEx)CustomClassLoadedObject.read(in);
    }

    public String toString() {
        return String.format("%s(%d) -> %s(%d)", this.sourceVertex == null ? "null" : this.sourceVertex.name(), this.sourceOrdinal, this.destVertex == null ? "null" : this.destVertex.name(), this.destOrdinal);
    }
}

