/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.function;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import java.io.Serializable;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface TriPredicate<T, U, V>
extends Serializable {
    public boolean testEx(T var1, U var2, V var3) throws Exception;

    default public boolean test(T t2, U u, V v) {
        try {
            return this.testEx(t2, u, v);
        }
        catch (Exception e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    default public TriPredicate<T, U, V> and(@Nonnull TriPredicate<? super T, ? super U, ? super V> other) {
        Preconditions.checkNotNull(other, "other");
        return (t2, u, v) -> this.test(t2, u, v) && other.test(t2, u, v);
    }

    default public TriPredicate<T, U, V> negate() {
        return (t2, u, v) -> !this.test(t2, u, v);
    }

    default public TriPredicate<T, U, V> or(@Nonnull TriPredicate<? super T, ? super U, ? super V> other) {
        Preconditions.checkNotNull(other, "other");
        return (t2, u, v) -> this.test(t2, u, v) || other.test(t2, u, v);
    }
}

